
<?php $__env->startSection('content'); ?>
<style>
    .category-page-wrapper { max-width: 1200px; margin: 0 auto; padding: 20px 16px; }
    
    /* Breadcrumb */
    .breadcrumb { font-size: 13px; color: #666; margin-bottom: 20px; }
    .breadcrumb a { color: #7db64f; text-decoration: none; }
    .breadcrumb a:hover { text-decoration: underline; }
    .breadcrumb span { color: #999; margin: 0 8px; }
    
    /* Filter and Sort Bar */
    .filter-sort-bar { 
        display: flex; 
        justify-content: space-between; 
        align-items: center; 
        padding: 16px; 
        background: #f9fafb; 
        border-radius: 8px; 
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px;
    }
    .filter-sort-bar select {
        padding: 8px 12px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        background: #fff;
        font-size: 14px;
        cursor: pointer;
    }
    .product-count {
        font-size: 14px;
        color: #666;
        font-weight: 500;
    }
    
    /* Product Grid */
    .products-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
        gap: 20px;
        margin-bottom: 40px;
    }
    .product-card {
        background: #fff;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        padding: 16px;
        transition: all 0.3s;
        position: relative;
        overflow: hidden;
    }
    .product-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 16px rgba(0,0,0,0.1);
        border-color: #7db64f;
    }
    .product-badge {
        position: absolute;
        top: 12px;
        right: 12px;
        background: #7db64f;
        color: #fff;
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 11px;
        font-weight: 600;
        z-index: 2;
    }
    .product-badge.natural {
        background: #10b981;
    }
    .product-image {
        width: 100%;
        height: 180px;
        object-fit: cover;
        border-radius: 6px;
        margin-bottom: 12px;
        background: #f9fafb;
    }
    .product-rating {
        display: flex;
        align-items: center;
        gap: 4px;
        margin-bottom: 8px;
    }
    .product-rating .stars {
        color: #fbbf24;
        font-size: 14px;
    }
    .product-name {
        font-size: 14px;
        font-weight: 600;
        color: #1f2937;
        margin-bottom: 8px;
        line-height: 1.4;
        min-height: 40px;
    }
    .product-weight {
        font-size: 12px;
        color: #6b7280;
        margin-bottom: 8px;
    }
    .product-brand {
        font-size: 12px;
        color: #9ca3af;
        margin-bottom: 12px;
    }
    .product-price {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 12px;
    }
    .product-price .current {
        font-size: 18px;
        font-weight: 700;
        color: #7db64f;
    }
    .product-price .old {
        font-size: 14px;
        color: #9ca3af;
        text-decoration: line-through;
    }
    .product-actions {
        display: flex;
        gap: 8px;
    }
    .quantity-selector {
        display: flex;
        align-items: center;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        overflow: hidden;
    }
    .quantity-selector button {
        background: #f9fafb;
        border: none;
        width: 32px;
        height: 36px;
        cursor: pointer;
        font-size: 16px;
        color: #666;
    }
    .quantity-selector button:hover {
        background: #e5e7eb;
    }
    .quantity-selector input {
        width: 50px;
        height: 36px;
        border: none;
        text-align: center;
        font-size: 14px;
    }
    .add-to-cart-btn {
        flex: 1;
        background: #f97316;
        color: #fff;
        border: none;
        padding: 10px 16px;
        border-radius: 6px;
        font-weight: 600;
        font-size: 13px;
        cursor: pointer;
        transition: all 0.3s;
    }
    .add-to-cart-btn:hover {
        background: #ea580c;
    }
    
    /* Pagination */
    .pagination {
        display: flex;
        justify-content: center;
        gap: 8px;
        margin-top: 40px;
    }
    .pagination a, .pagination span {
        padding: 8px 12px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        text-decoration: none;
        color: #3f3f3f;
    }
    .pagination a:hover {
        background: #f9fafb;
        border-color: #7db64f;
    }
    .pagination .active {
        background: #7db64f;
        color: #fff;
        border-color: #7db64f;
    }
    
    @media (max-width: 768px) {
        .filter-sort-bar {
            flex-direction: column;
            align-items: stretch;
        }
        .products-grid {
            grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
            gap: 12px;
        }
        .product-card {
            padding: 12px;
        }
        .product-image {
            height: 140px;
        }
    }
</style>

<div class="category-page-wrapper">
    <!-- Breadcrumb -->
    <div class="breadcrumb">
        <a href="<?php echo e(route('home')); ?>">Anasayfa</a>
        <span>/</span>
        <?php if($category->parent): ?>
            <a href="<?php echo e(route('category.show', $category->parent->slug)); ?>"><?php echo e($category->parent->name); ?></a>
            <span>/</span>
        <?php endif; ?>
        <span><?php echo e($category->name); ?></span>
    </div>

    <!-- Filter and Sort Bar -->
    <div class="filter-sort-bar">
        <div style="display: flex; gap: 12px; align-items: center; flex-wrap: wrap;">
            <?php if($brands->count() > 0): ?>
                <select name="brand" onchange="window.location.href='<?php echo e(route('category.show', $category->slug)); ?>?brand=' + this.value + '&sort=<?php echo e(request('sort')); ?>'">
                    <option value="">Tüm Markalar</option>
                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($brand); ?>" <?php echo e(request('brand') == $brand ? 'selected' : ''); ?>><?php echo e($brand); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            <?php endif; ?>
            
            <select name="sort" onchange="window.location.href='<?php echo e(route('category.show', $category->slug)); ?>?sort=' + this.value + '&brand=<?php echo e(request('brand')); ?>'">
                <option value="default" <?php echo e(request('sort') == 'default' ? 'selected' : ''); ?>>Varsayılan</option>
                <option value="price_asc" <?php echo e(request('sort') == 'price_asc' ? 'selected' : ''); ?>>Fiyata Göre (Artan)</option>
                <option value="price_desc" <?php echo e(request('sort') == 'price_desc' ? 'selected' : ''); ?>>Fiyata Göre (Azalan)</option>
                <option value="name_asc" <?php echo e(request('sort') == 'name_asc' ? 'selected' : ''); ?>>Ürün Adına Göre (A>Z)</option>
                <option value="name_desc" <?php echo e(request('sort') == 'name_desc' ? 'selected' : ''); ?>>Ürün Adına Göre (Z<A)</option>
                <option value="stock" <?php echo e(request('sort') == 'stock' ? 'selected' : ''); ?>>Stoktakiler</option>
            </select>
        </div>
        
        <div class="product-count">
            <?php echo e($products->total()); ?> Ürün
        </div>
    </div>

    <!-- Products Grid -->
    <?php if($products->count() > 0): ?>
        <div class="products-grid">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="product-card">
                    <?php if($product->sale_price && $product->sale_price < $product->price): ?>
                        <span class="product-badge">%<?php echo e($product->discount_percentage); ?> İNDİRİM</span>
                    <?php endif; ?>
                    <?php if($product->is_featured): ?>
                        <span class="product-badge natural">DOĞAL</span>
                    <?php endif; ?>
                    
                    <img src="<?php echo e($product->image ?? '/assets/placeholder-product.jpg'); ?>" alt="<?php echo e($product->name); ?>" class="product-image">
                    
                    <div class="product-rating">
                        <span class="stars">★★★★★</span>
                    </div>
                    
                    <div class="product-name"><?php echo e($product->name); ?></div>
                    
                    <?php if($product->weight): ?>
                        <div class="product-weight"><?php echo e($product->weight); ?></div>
                    <?php endif; ?>
                    
                    <?php if($product->brand): ?>
                        <div class="product-brand"><?php echo e($product->brand); ?></div>
                    <?php endif; ?>
                    
                    <div class="product-price">
                        <span class="current"><?php echo e(number_format($product->final_price, 2)); ?> ₺</span>
                        <?php if($product->sale_price && $product->sale_price < $product->price): ?>
                            <span class="old"><?php echo e(number_format($product->price, 2)); ?> ₺</span>
                        <?php endif; ?>
                    </div>
                    
                    <div class="product-actions">
                        <div class="quantity-selector">
                            <button type="button" onclick="decreaseQuantity(<?php echo e($product->id); ?>)">-</button>
                            <input type="number" id="qty-<?php echo e($product->id); ?>" value="1" min="1" max="<?php echo e($product->stock_quantity); ?>">
                            <button type="button" onclick="increaseQuantity(<?php echo e($product->id); ?>)">+</button>
                        </div>
                        <button class="add-to-cart-btn" onclick="addToCart(<?php echo e($product->id); ?>)">SEPETE EKLE</button>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Pagination -->
        <div class="pagination">
            <?php echo e($products->links()); ?>

        </div>
    <?php else: ?>
        <div style="text-align: center; padding: 60px 20px;">
            <p style="font-size: 18px; color: #6b7280; margin-bottom: 12px;">Bu kategoride henüz ürün bulunmuyor.</p>
            <a href="<?php echo e(route('home')); ?>" style="color: #7db64f; text-decoration: none; font-weight: 600;">Anasayfaya Dön</a>
        </div>
    <?php endif; ?>
</div>

<script>
function increaseQuantity(productId) {
    const input = document.getElementById('qty-' + productId);
    const max = parseInt(input.getAttribute('max'));
    const current = parseInt(input.value);
    if (current < max) {
        input.value = current + 1;
    }
}

function decreaseQuantity(productId) {
    const input = document.getElementById('qty-' + productId);
    const current = parseInt(input.value);
    if (current > 1) {
        input.value = current - 1;
    }
}

function addToCart(productId) {
    const quantity = document.getElementById('qty-' + productId).value;
    // TODO: Implement add to cart functionality
    alert('Ürün sepete eklendi! (Ürün ID: ' + productId + ', Miktar: ' + quantity + ')');
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/category/show.blade.php ENDPATH**/ ?>