
<?php $__env->startSection('content'); ?>
<?php
    use Illuminate\Support\Str;
?>
<h1>Slider Düzenle: <?php echo e($slider->name); ?></h1>

<form method="POST" action="<?php echo e(route('admin.sliders.update', $slider)); ?>" enctype="multipart/form-data" class="mt">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
    
    <div class="form-group">
        <label>Slider Adı *</label>
        <input type="text" name="name" value="<?php echo e(old('name', $slider->name)); ?>" required class="form-control">
    </div>

    <div class="form-group">
        <label>Slider Tipi *</label>
        <select name="type" class="form-control" required>
            <option value="banner" <?php echo e(old('type', $slider->type) == 'banner' ? 'selected' : ''); ?>>Banner (Görsel Slider)</option>
            <option value="product" <?php echo e(old('type', $slider->type) == 'product' ? 'selected' : ''); ?>>Ürün Slider</option>
        </select>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Sıra</label>
            <input type="number" name="order" value="<?php echo e(old('order', $slider->order)); ?>" class="form-control" min="0">
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', $slider->is_active) ? 'checked' : ''); ?>>
                Aktif
            </label>
        </div>
    </div>

    <div class="flex mt">
        <button type="submit" class="btn">Güncelle</button>
        <a class="btn secondary" href="<?php echo e(route('admin.sliders.index')); ?>">İptal</a>
    </div>
</form>

<hr style="margin:30px 0;border:none;border-top:2px solid #e5e7eb;">

<h2>Öğe Ekle</h2>

<?php if($slider->type === 'product'): ?>
    <form method="POST" action="<?php echo e(route('admin.sliders.addItem', $slider)); ?>" class="mt">
        <?php echo csrf_field(); ?>
        <div class="form-row" style="display:grid;grid-template-columns:2fr 1fr;gap:20px;">
            <div class="form-group">
                <label>Ürün Seç *</label>
                <select name="product_id" class="form-control" required>
                    <option value="">Ürün Seçin</option>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $exists = $slider->items->where('product_id', $product->id)->count() > 0;
                        ?>
                        <?php if(!$exists): ?>
                            <option value="<?php echo e($product->id); ?>"><?php echo e($product->name); ?></option>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <small>Slider'da zaten bulunan ürünler listede görünmez</small>
            </div>
            <div class="form-group">
                <label>Sıra</label>
                <input type="number" name="order" value="<?php echo e($slider->items->max('order') + 1 ?? 0); ?>" class="form-control" min="0">
            </div>
        </div>
        <button type="submit" class="btn">Ürün Ekle</button>
    </form>
<?php else: ?>
    <form method="POST" action="<?php echo e(route('admin.sliders.addItem', $slider)); ?>" enctype="multipart/form-data" class="mt">
        <?php echo csrf_field(); ?>
        <div class="form-group">
            <label>Başlık *</label>
            <input type="text" name="title" value="<?php echo e(old('title')); ?>" required class="form-control">
        </div>
        <div class="form-group">
            <label>Açıklama</label>
            <textarea name="description" rows="3" class="form-control"><?php echo e(old('description')); ?></textarea>
        </div>
        <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
            <div class="form-group">
                <label>Görsel *</label>
                <input type="file" name="image" accept="image/*" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Link</label>
                <input type="text" name="link" value="<?php echo e(old('link')); ?>" class="form-control" placeholder="https://...">
            </div>
        </div>
        <div class="form-group">
            <label>Sıra</label>
            <input type="number" name="order" value="<?php echo e($slider->items->max('order') + 1 ?? 0); ?>" class="form-control" min="0">
        </div>
        <button type="submit" class="btn">Banner Ekle</button>
    </form>
<?php endif; ?>

<?php if(session('success')): ?>
    <div class="alert alert-success mt"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger mt">
        <ul style="margin:0;padding-left:20px;">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<hr style="margin:30px 0;border:none;border-top:2px solid #e5e7eb;">

<h2>Mevcut Öğeler (<?php echo e($slider->items->count()); ?>)</h2>

<?php if($slider->items->count() > 0): ?>
    <div style="display:grid;grid-template-columns:repeat(auto-fill, minmax(250px, 1fr));gap:20px;margin-top:20px;">
        <?php $__currentLoopData = $slider->items->sortBy('order'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:15px;">
                <?php if($slider->type === 'product' && $item->product): ?>
                    <img src="<?php echo e($item->product->image ? asset($item->product->image) : asset('images/placeholder.png')); ?>" alt="<?php echo e($item->product->name); ?>" style="width:100%;height:150px;object-fit:cover;border-radius:6px;margin-bottom:10px;">
                    <div style="font-weight:600;color:#333;margin-bottom:5px;"><?php echo e($item->product->name); ?></div>
                    <div style="font-size:12px;color:#6b7280;margin-bottom:10px;">Sıra: <?php echo e($item->order); ?></div>
                <?php else: ?>
                    <?php if($item->image): ?>
                        <img src="<?php echo e(asset($item->image)); ?>" alt="<?php echo e($item->title); ?>" style="width:100%;height:150px;object-fit:cover;border-radius:6px;margin-bottom:10px;">
                    <?php endif; ?>
                    <div style="font-weight:600;color:#333;margin-bottom:5px;"><?php echo e($item->title); ?></div>
                    <?php if($item->description): ?>
                        <div style="font-size:12px;color:#6b7280;margin-bottom:5px;"><?php echo e(Str::limit($item->description, 50)); ?></div>
                    <?php endif; ?>
                    <div style="font-size:12px;color:#6b7280;margin-bottom:10px;">Sıra: <?php echo e($item->order); ?></div>
                <?php endif; ?>
                <form action="<?php echo e(route('admin.sliders.removeItem', $item)); ?>" method="POST" onsubmit="return confirm('Bu öğeyi silmek istediğinize emin misiniz?');">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-sm btn-danger" style="width:100%;">Kaldır</button>
                </form>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php else: ?>
    <p style="color:#9ca3af;text-align:center;padding:40px;">Henüz öğe eklenmemiş.</p>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/sliders/edit.blade.php ENDPATH**/ ?>