﻿
<?php $__env->startSection('content'); ?>
    <style>
        .product-wrapper { max-width: 1200px; margin: 0 auto; padding: 30px 16px; }
        
        /* Breadcrumb */
        .breadcrumb { margin-bottom: 20px; font-size: 14px; color: #666; }
        .breadcrumb a { color: #73ae43; text-decoration: none; }
        .breadcrumb a:hover { text-decoration: underline; }
        .breadcrumb span { margin: 0 8px; color: #999; }
        
        /* Product Container */
        .product-container { display: grid; grid-template-columns: 1fr 1fr; gap: 40px; margin-bottom: 50px; }
        @media (max-width: 768px) {
            .product-container { grid-template-columns: 1fr; gap: 30px; }
        }
        
        /* Product Images */
        .product-images { position: sticky; top: 20px; }
        .product-main-image { width: 100%; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 16px rgba(0,0,0,0.1); margin-bottom: 15px; background: #f9f9f9; }
        .product-main-image img { width: 100%; height: auto; display: block; }
        .product-thumbnails { display: grid; grid-template-columns: repeat(4, 1fr); gap: 10px; }
        .product-thumbnail { border-radius: 8px; overflow: hidden; cursor: pointer; border: 2px solid transparent; transition: all 0.3s; }
        .product-thumbnail:hover, .product-thumbnail.active { border-color: #73ae43; }
        .product-thumbnail img { width: 100%; height: 80px; object-fit: cover; display: block; }
        
        /* Product Info */
        .product-info h1 { font-size: 28px; font-weight: 700; color: #333; margin-bottom: 15px; line-height: 1.3; }
        .product-rating { display: flex; align-items: center; gap: 10px; margin-bottom: 20px; }
        .product-rating .stars { display: flex; gap: 4px; }
        .product-rating .star { font-size: 22px; color: #ddd; transition: all 0.2s; cursor: pointer; }
        .product-rating .star.filled { color: #ffc107; }
        .product-rating .star.half { background: linear-gradient(90deg, #ffc107 50%, #ddd 50%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; }
        .product-rating .reviews { color: #666; font-size: 14px; }
        
        /* Star Rating Input */
        .star-rating-input { display: flex; gap: 8px; align-items: center; margin: 20px 0; }
        .star-rating-input .stars { display: flex; gap: 6px; }
        .star-rating-input .star { font-size: 32px; color: #ddd; cursor: pointer; transition: all 0.2s; }
        .star-rating-input .star:hover { color: #ffc107; transform: scale(1.1); }
        .star-rating-input .star.selected { color: #ffc107; }
        .star-rating-input .star.selected ~ .star { color: #ddd; }
        
        /* Reviews Section */
        .reviews-section { margin-top: 50px; padding-top: 30px; border-top: 2px solid #e5e7eb; }
        .reviews-section h3 { font-size: 24px; font-weight: 700; color: #333; margin-bottom: 20px; }
        .review-form { background: #f9fafb; padding: 25px; border-radius: 12px; margin-bottom: 30px; }
        .review-form textarea { width: 100%; padding: 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 14px; resize: vertical; min-height: 100px; }
        .review-form button { background: #ff6b35; color: #fff; padding: 12px 24px; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.3s; margin-top: 15px; }
        .review-form button:hover { background: #e55a2b; }
        .review-item { background: #fff; padding: 20px; border-radius: 8px; margin-bottom: 15px; border: 1px solid #e5e7eb; }
        .review-item-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }
        .review-item-user { font-weight: 600; color: #333; }
        .review-item-date { color: #999; font-size: 12px; }
        .review-item-rating { display: flex; gap: 4px; margin-bottom: 10px; }
        .review-item-comment { color: #666; line-height: 1.6; }
        
        .product-price-section { background: linear-gradient(135deg, #f0f9f4 0%, #d1fae5 100%); padding: 20px; border-radius: 12px; margin-bottom: 25px; }
        .product-price { font-size: 36px; font-weight: 700; color: #73ae43; margin-bottom: 8px; }
        .product-old-price { font-size: 20px; color: #999; text-decoration: line-through; margin-bottom: 8px; }
        .product-discount { display: inline-block; background: #10b981; color: #fff; padding: 6px 12px; border-radius: 6px; font-size: 14px; font-weight: 600; margin-left: 10px; }
        .product-tax { font-size: 14px; color: #666; }
        
        .product-description { margin-bottom: 30px; }
        .product-description h3 { font-size: 18px; font-weight: 600; color: #333; margin-bottom: 12px; }
        .product-description p { color: #666; line-height: 1.8; font-size: 15px; }
        
        .product-features { margin-bottom: 30px; }
        .product-features ul { list-style: none; padding: 0; }
        .product-features li { padding: 10px 0; border-bottom: 1px solid #eee; color: #666; }
        .product-features li:last-child { border-bottom: none; }
        .product-features li strong { color: #333; margin-right: 10px; }
        
        /* Quantity & Actions */
        .product-actions { margin-bottom: 30px; }
        .quantity-selector { display: flex; align-items: center; gap: 15px; margin-bottom: 20px; }
        .quantity-btn { width: 40px; height: 40px; border: 2px solid #ff6b35; background: #fff; color: #ff6b35; border-radius: 8px; font-size: 20px; cursor: pointer; display: flex; align-items: center; justify-content: center; transition: all 0.3s; }
        .quantity-btn:hover { background: #ff6b35; color: #fff; }
        .quantity-input { width: 80px; height: 40px; border: 2px solid #ddd; border-radius: 8px; text-align: center; font-size: 18px; font-weight: 600; }
        
        .action-buttons { display: flex; gap: 15px; }
        .btn-primary { flex: 1; background: #ff6b35; color: #fff; padding: 16px 24px; border-radius: 8px; font-size: 16px; font-weight: 600; text-align: center; text-decoration: none; border: none; cursor: pointer; transition: all 0.3s; display: flex; align-items: center; justify-content: center; gap: 8px; }
        .btn-primary:hover { background: #e55a2b; transform: translateY(-2px); box-shadow: 0 6px 16px rgba(255,107,53,0.3); }
        .btn-secondary { width: 50px; height: 50px; background: #fff; border: 2px solid #ff6b35; color: #ff6b35; border-radius: 8px; display: flex; align-items: center; justify-content: center; cursor: pointer; transition: all 0.3s; font-size: 20px; }
        .btn-secondary:hover { background: #ff6b35; color: #fff; }
        
        /* Related Products */
        .related-products { margin-top: 60px; }
        .related-products h2 { font-size: 24px; font-weight: 700; margin-bottom: 25px; color: #333; padding-bottom: 10px; border-bottom: 3px solid #73ae43; }
        .related-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 20px; }
        .related-card { background: #fff; border: 1px solid #eee; border-radius: 8px; padding: 15px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); transition: all 0.3s; }
        .related-card:hover { transform: translateY(-5px); box-shadow: 0 6px 16px rgba(0,0,0,0.12); }
        .related-card img { width: 100%; height: 160px; object-fit: cover; border-radius: 6px; margin-bottom: 12px; }
        .related-card .name { font-weight: 600; font-size: 14px; color: #333; margin-bottom: 8px; }
        .related-card .price { font-weight: 700; color: #73ae43; font-size: 16px; }
        
        /* Product Tabs */
        .product-tabs { margin-top: 50px; }
        .product-tabs-nav { display: flex; gap: 0; border-bottom: 2px solid #e5e7eb; margin-bottom: 30px; }
        .product-tabs-nav button { background: none; border: none; padding: 15px 30px; font-size: 16px; font-weight: 600; color: #666; cursor: pointer; border-bottom: 3px solid transparent; transition: all 0.3s; position: relative; top: 2px; }
        .product-tabs-nav button:hover { color: #73ae43; }
        .product-tabs-nav button.active { color: #73ae43; border-bottom-color: #73ae43; }
        .product-tabs-content { display: none; }
        .product-tabs-content.active { display: block; }
        .product-tabs-content h3 { font-size: 20px; font-weight: 700; color: #333; margin-bottom: 15px; }
        .product-tabs-content p { color: #666; line-height: 1.8; font-size: 15px; margin-bottom: 15px; }
        .product-tabs-content ul { list-style: none; padding: 0; }
        .product-tabs-content li { padding: 10px 0; border-bottom: 1px solid #eee; color: #666; }
        .product-tabs-content li:last-child { border-bottom: none; }
        .product-tabs-content li strong { color: #333; margin-right: 10px; }
    </style>

    <div class="product-wrapper">
        <!-- Breadcrumb -->
        <div class="breadcrumb">
            <a href="<?php echo e(route('home')); ?>">Ana Sayfa</a>
            <span>/</span>
            <?php if($product->category): ?>
                <a href="<?php echo e(route('category.show', $product->category->slug)); ?>"><?php echo e($product->category->name); ?></a>
                <span>/</span>
            <?php endif; ?>
            <span><?php echo e($product->name); ?></span>
        </div>

        <!-- Product Container -->
        <div class="product-container">
            <!-- Product Images -->
            <div class="product-images">
                <div class="product-main-image">
                    <img id="mainImage" src="<?php echo e($product->image ? asset($product->image) : asset('images/placeholder.png')); ?>" alt="<?php echo e($product->name); ?>">
                </div>
                <?php
                    $images = $product->gallery ?? [];
                    if ($product->image) {
                        array_unshift($images, $product->image);
                    }
                ?>
                <?php if(count($images) > 1): ?>
                    <div class="product-thumbnails">
                        <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="product-thumbnail <?php echo e($index === 0 ? 'active' : ''); ?>" onclick="changeImage('<?php echo e(asset($image)); ?>')">
                                <img src="<?php echo e(asset($image)); ?>" alt="<?php echo e($product->name); ?>">
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Product Info -->
            <div class="product-info">
                <h1><?php echo e($product->name); ?></h1>
                
                <?php if($product->farm_name || $product->origin): ?>
                    <div style="margin-bottom: 15px; color: #666; font-size: 14px;">
                        <?php if($product->farm_name): ?>
                            <span><?php echo e($product->farm_name); ?></span>
                        <?php endif; ?>
                        <?php if($product->origin): ?>
                            <?php if($product->farm_name): ?> - <?php endif; ?>
                            <span><?php echo e($product->origin); ?></span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                
                <div class="product-rating">
                    <div class="stars">
                        <?php
                            $avgRating = $product->average_rating ?? $product->rating;
                            $fullStars = floor($avgRating);
                            $hasHalfStar = ($avgRating - $fullStars) >= 0.5;
                        ?>
                        <?php for($i = 0; $i < 5; $i++): ?>
                            <?php if($i < $fullStars): ?>
                                <span class="star filled">★</span>
                            <?php elseif($i == $fullStars && $hasHalfStar): ?>
                                <span class="star half">★</span>
                            <?php else: ?>
                                <span class="star">☆</span>
                            <?php endif; ?>
                        <?php endfor; ?>
                    </div>
                    <span class="reviews">(<?php echo e($product->review_count ?? 0); ?> değerlendirme)</span>
                </div>

                <div class="product-price-section">
                    <div class="product-price">
                        <?php if($product->sale_price): ?>
                            <?php echo e(number_format($product->sale_price, 2, ',', '.')); ?> TL
                            <?php if($product->price > $product->sale_price): ?>
                                <?php
                                    $discount = round((($product->price - $product->sale_price) / $product->price) * 100);
                                ?>
                                <span class="product-discount">%<?php echo e($discount); ?> İndirim</span>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php echo e(number_format($product->price, 2, ',', '.')); ?> TL
                        <?php endif; ?>
                    </div>
                    <?php if($product->sale_price && $product->price > $product->sale_price): ?>
                        <div class="product-old-price"><?php echo e(number_format($product->price, 2, ',', '.')); ?> TL</div>
                    <?php endif; ?>
                    <div class="product-tax">KDV Dahil</div>
                </div>

                <div class="product-features">
                    <h3>Ürün Özellikleri</h3>
                    <ul>
                        <?php if($product->is_organic): ?>
                            <li><strong>Organik:</strong> Evet</li>
                        <?php endif; ?>
                        <?php if($product->weight): ?>
                            <li><strong>Ağırlık/Miktar:</strong> <?php echo e($product->weight); ?></li>
                        <?php endif; ?>
                        <?php if($product->origin): ?>
                            <li><strong>Menşei:</strong> <?php echo e($product->origin); ?></li>
                        <?php endif; ?>
                        <?php if($product->farm_name): ?>
                            <li><strong>Çiftlik:</strong> <?php echo e($product->farm_name); ?></li>
                        <?php endif; ?>
                        <?php if($product->brand): ?>
                            <li><strong>Marka:</strong> <?php echo e($product->brand); ?></li>
                        <?php endif; ?>
                        <li><strong>Stok Durumu:</strong> <?php echo e($product->in_stock ? 'Stokta Var' : 'Stokta Yok'); ?></li>
                        <?php if($product->stock_quantity > 0): ?>
                            <li><strong>Stok Miktarı:</strong> <?php echo e($product->stock_quantity); ?> adet</li>
                        <?php endif; ?>
                    </ul>
                </div>

                <div class="product-actions">
                    <div class="quantity-selector">
                        <label style="font-weight: 600; color: #333;">Adet:</label>
                        <button class="quantity-btn" onclick="decreaseQuantity()">-</button>
                        <input type="number" id="quantity" class="quantity-input" value="1" min="1" max="<?php echo e($product->stock_quantity > 0 ? $product->stock_quantity : 99); ?>">
                        <button class="quantity-btn" onclick="increaseQuantity()">+</button>
                    </div>
                    
                    <div class="action-buttons">
                        <button class="btn-primary" onclick="addToCart(<?php echo e($product->id); ?>)" <?php echo e(!$product->in_stock ? 'disabled' : ''); ?>>
                            <span>🛒</span>
                            <span><?php echo e($product->in_stock ? 'SEPETE EKLE' : 'STOKTA YOK'); ?></span>
                        </button>
                        <button class="btn-secondary" onclick="toggleFavorite(<?php echo e($product->id); ?>)" title="Favorilere Ekle">
                            ❤️
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Product Tabs -->
        <div class="product-tabs">
            <div class="product-tabs-nav">
                <button class="active" onclick="showTab('description')">Açıklama</button>
                <button onclick="showTab('delivery')">TESLİMAT</button>
                <button onclick="showTab('certificates')">SERTİFİKALAR</button>
            </div>
            
            <div id="tab-description" class="product-tabs-content active">
                <?php if($product->description_detail): ?>
                    <div><?php echo nl2br(e($product->description_detail)); ?></div>
                <?php elseif($product->description): ?>
                    <div><?php echo nl2br(e($product->description)); ?></div>
                <?php else: ?>
                    <p>Bu ürün için henüz detaylı açıklama eklenmemiş.</p>
                <?php endif; ?>
            </div>
            
            <div id="tab-delivery" class="product-tabs-content">
                <?php if($product->delivery_info): ?>
                    <div><?php echo nl2br(e($product->delivery_info)); ?></div>
                <?php else: ?>
                    <p>Bu ürün için henüz teslimat bilgisi eklenmemiş.</p>
                <?php endif; ?>
            </div>
            
            <div id="tab-certificates" class="product-tabs-content">
                <?php if($product->certificates_info): ?>
                    <div><?php echo nl2br(e($product->certificates_info)); ?></div>
                <?php else: ?>
                    <p>Bu ürün için henüz sertifika bilgisi eklenmemiş.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Reviews Section -->
        <div class="reviews-section">
            <h3>Değerlendirmeler (<?php echo e($product->review_count ?? 0); ?>)</h3>
            
            <?php if(isset($canReview) && $canReview && !isset($userReview)): ?>
                <div class="review-form">
                    <form action="<?php echo e(route('reviews.store', $product->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="star-rating-input">
                            <label style="font-weight: 600; color: #333;">Puanınız:</label>
                            <div class="stars">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <span class="star" onclick="selectRating(<?php echo e($i); ?>)" data-rating="<?php echo e($i); ?>">☆</span>
                                <?php endfor; ?>
                            </div>
                            <input type="hidden" name="rating" id="rating-input" required>
                        </div>
                        <textarea name="comment" placeholder="Yorumunuzu yazın (isteğe bağlı)..." class="form-control"></textarea>
                        <?php $__errorArgs = ['rating'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: #ef4444; font-size: 14px; margin-top: 5px;"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php $__errorArgs = ['error'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: #ef4444; font-size: 14px; margin-top: 5px;"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php if(session('success')): ?>
                            <div style="color: #10b981; font-size: 14px; margin-top: 5px;"><?php echo e(session('success')); ?></div>
                        <?php endif; ?>
                        <button type="submit">Yorumu Gönder</button>
                    </form>
                </div>
            <?php elseif(isset($userReview) && $userReview): ?>
                <div style="background: #f0f9f4; padding: 15px; border-radius: 8px; margin-bottom: 20px; color: #10b981;">
                    ✓ Bu ürüne zaten yorum yaptınız.
                </div>
            <?php elseif(!auth()->check()): ?>
                <div style="background: #fef3c7; padding: 15px; border-radius: 8px; margin-bottom: 20px; color: #92400e;">
                    Yorum yapmak için <a href="<?php echo e(route('auth.login')); ?>" style="color: #73ae43; font-weight: 600;">giriş yapın</a> ve bu ürünü satın alın.
                </div>
            <?php elseif(isset($canReview) && !$canReview): ?>
                <div style="background: #fef3c7; padding: 15px; border-radius: 8px; margin-bottom: 20px; color: #92400e;">
                    Bu ürüne yorum yapmak için önce satın alma yapmalısınız.
                </div>
            <?php endif; ?>

            <?php if(isset($reviews) && $reviews->count() > 0): ?>
                <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="review-item">
                        <div class="review-item-header">
                            <div class="review-item-user"><?php echo e($review->user->name ?? 'Anonim'); ?></div>
                            <div class="review-item-date"><?php echo e($review->created_at->format('d.m.Y')); ?></div>
                        </div>
                        <div class="review-item-rating">
                            <?php for($i = 0; $i < 5; $i++): ?>
                                <?php if($i < $review->rating): ?>
                                    <span class="star filled">★</span>
                                <?php else: ?>
                                    <span class="star">☆</span>
                                <?php endif; ?>
                            <?php endfor; ?>
                        </div>
                        <?php if($review->comment): ?>
                            <div class="review-item-comment"><?php echo e($review->comment); ?></div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                <div style="margin-top: 20px;">
                    <?php echo e($reviews->links()); ?>

                </div>
            <?php else: ?>
                <p style="color: #666; text-align: center; padding: 40px;">Henüz değerlendirme yapılmamış.</p>
            <?php endif; ?>
        </div>

        <!-- Related Products -->
        <?php if(isset($relatedProducts) && $relatedProducts->count() > 0): ?>
            <div class="related-products">
                <h2>Benzer Ürünler</h2>
                <div class="related-grid">
                    <?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="related-card">
                            <a href="<?php echo e(route('product.show', ['slug' => $related->slug])); ?>">
                                <img src="<?php echo e($related->image ? asset($related->image) : asset('images/placeholder.png')); ?>" alt="<?php echo e($related->name); ?>">
                            </a>
                            <div class="name"><?php echo e($related->name); ?></div>
                            <div class="price">
                                <?php if($related->sale_price): ?>
                                    <?php echo e(number_format($related->sale_price, 2, ',', '.')); ?> TL
                                <?php else: ?>
                                    <?php echo e(number_format($related->price, 2, ',', '.')); ?> TL
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <script>
        function changeImage(imageSrc) {
            document.getElementById('mainImage').src = imageSrc;
            document.querySelectorAll('.product-thumbnail').forEach(thumb => {
                thumb.classList.remove('active');
            });
            event.currentTarget.classList.add('active');
        }

        function increaseQuantity() {
            const input = document.getElementById('quantity');
            const max = parseInt(input.getAttribute('max')) || 99;
            const current = parseInt(input.value) || 1;
            if (current < max) {
                input.value = current + 1;
            }
        }

        function decreaseQuantity() {
            const input = document.getElementById('quantity');
            const current = parseInt(input.value) || 1;
            if (current > 1) {
                input.value = current - 1;
            }
        }

        function addToCart(productId) {
            const quantity = document.getElementById('quantity').value;
            // Backend entegrasyonu için hazır - AJAX çağrısı yapılacak
            alert('Ürün sepete eklendi! (Backend entegrasyonu sonrası aktif olacak)');
        }

        function toggleFavorite(productId) {
            // Backend entegrasyonu için hazır - AJAX çağrısı yapılacak
            alert('Favorilere eklendi! (Backend entegrasyonu sonrası aktif olacak)');
        }

        function showTab(tabName) {
            // Hide all tabs
            document.querySelectorAll('.product-tabs-content').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // Remove active class from all buttons
            document.querySelectorAll('.product-tabs-nav button').forEach(btn => {
                btn.classList.remove('active');
            });
            
            // Show selected tab
            document.getElementById('tab-' + tabName).classList.add('active');
            
            // Add active class to clicked button
            event.target.classList.add('active');
        }

        function selectRating(rating) {
            document.getElementById('rating-input').value = rating;
            const stars = document.querySelectorAll('.star-rating-input .star');
            stars.forEach((star, index) => {
                if (index < rating) {
                    star.classList.add('selected');
                    star.textContent = '★';
                } else {
                    star.classList.remove('selected');
                    star.textContent = '☆';
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/product/show.blade.php ENDPATH**/ ?>