<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\MenuController;
use App\Http\Controllers\Admin\AuthController as AdminAuthController;
use App\Http\Controllers\Admin\UserController;

Route::get('/', function () {
    // Get sliders
    $mainSlider = \App\Models\Slider::where('slug', 'ana-slider')
        ->where('is_active', true)
        ->with('activeItems')
        ->first();
    
    $weeklySlider = \App\Models\Slider::where('slug', 'haftanin-urunleri')
        ->where('is_active', true)
        ->with(['activeItems.product'])
        ->first();
    
    // Get product sections
    $mevsim = \App\Models\Product::active()->orderBy('order')->limit(12)->get();
    $cokSatan = \App\Models\Product::active()->where('is_featured', true)->orderBy('order')->limit(12)->get();
    $yeni = \App\Models\Product::active()->orderBy('created_at', 'desc')->limit(12)->get();

    return view('home', compact('mainSlider', 'weeklySlider', 'mevsim', 'cokSatan', 'yeni'));
})->name('home');

// Kullanıcı auth rotaları
Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('auth.login');
    Route::post('/login', [AuthController::class, 'login'])->name('auth.login.post');
    Route::get('/register', [AuthController::class, 'showRegister'])->name('auth.register');
    Route::post('/register', [AuthController::class, 'register'])->name('auth.register.post');
});

Route::post('/logout', [AuthController::class, 'logout'])->middleware('auth')->name('auth.logout');

// Kullanıcı profil rotaları
Route::middleware('auth')->group(function () {
    Route::get('/profile', [\App\Http\Controllers\ProfileController::class, 'index'])->name('profile.index');
    Route::put('/profile', [\App\Http\Controllers\ProfileController::class, 'update'])->name('profile.update');
});

// Üye paneli rotaları
Route::prefix('member')->name('member.')->middleware('auth')->group(function () {
    Route::get('/dashboard', [\App\Http\Controllers\Member\DashboardController::class, 'index'])->name('dashboard');
    
    // Adresler
    Route::resource('addresses', \App\Http\Controllers\Member\AddressController::class);
    
    // Siparişler
    Route::get('/orders', [\App\Http\Controllers\Member\OrderController::class, 'index'])->name('orders.index');
    Route::get('/orders/{order}', [\App\Http\Controllers\Member\OrderController::class, 'show'])->name('orders.show');
    
    // Favoriler
    Route::get('/favorites', [\App\Http\Controllers\Member\FavoriteController::class, 'index'])->name('favorites.index');
    Route::post('/favorites', [\App\Http\Controllers\Member\FavoriteController::class, 'store'])->name('favorites.store');
    Route::delete('/favorites/{favorite}', [\App\Http\Controllers\Member\FavoriteController::class, 'destroy'])->name('favorites.destroy');
    
    // İade ve İptal
    Route::get('/returns', [\App\Http\Controllers\Member\ReturnController::class, 'index'])->name('returns.index');
    Route::get('/returns/create/{order}', [\App\Http\Controllers\Member\ReturnController::class, 'create'])->name('returns.create');
    Route::post('/returns/{order}', [\App\Http\Controllers\Member\ReturnController::class, 'store'])->name('returns.store');
    Route::get('/returns/{return}', [\App\Http\Controllers\Member\ReturnController::class, 'show'])->name('returns.show');
    
    // Para Puanlarım
    Route::get('/para-puanlarim', [\App\Http\Controllers\Member\DashboardController::class, 'paraPuanlarim'])->name('para-puanlarim');
});

// Sayfa rotaları - özel sayfalar önce tanımlanmalı
Route::get('/Iletisim', [PageController::class, 'contact'])->name('contact');
Route::get('/blog', [PageController::class, 'blog'])->name('blog');
Route::get('/Sayfalar/sik-sorulan-sorular-8', [PageController::class, 'faq'])->name('faq');
Route::get('/Sayfalar/neden-tazemasa-26', [PageController::class, 'about'])->name('about');
Route::get('/Sayfalar/gizlilik-ve-guvenlik-9', [PageController::class, 'privacy'])->name('privacy');
Route::get('/Sayfalar/kullanim-kosullari-6', [PageController::class, 'terms'])->name('terms');

// Topbar sayfaları
Route::get('/para-puan-nedir', [PageController::class, 'paraPuanNedir'])->name('pages.para-puan-nedir');
Route::get('/organik-sertifikalar', [PageController::class, 'organikSertifikalar'])->name('pages.organik-sertifikalar');
Route::get('/siparis-takip', [PageController::class, 'siparisTakip'])->name('pages.siparis-takip');
Route::get('/sevkiyat', [PageController::class, 'sevkiyat'])->name('pages.sevkiyat');
Route::get('/yardim', [PageController::class, 'yardim'])->name('pages.yardim');

// Kategori sayfası
Route::get('/kategori/{slug}', [\App\Http\Controllers\CategoryController::class, 'show'])->name('category.show');

// Ürün sayfaları
Route::get('/urunler', [ProductController::class, 'index'])->name('product.index');
Route::get('/urun/{slug}', [ProductController::class, 'show'])->name('product.show');
Route::get('/arama', [ProductController::class, 'search'])->name('product.search');

// Kampanyalar
Route::get('/kampanyalar', [\App\Http\Controllers\CampaignController::class, 'index'])->name('campaigns.index');
Route::get('/kampanya/{slug}', [\App\Http\Controllers\CampaignController::class, 'show'])->name('campaigns.show');

// Reviews
Route::post('/urun/{product}/yorum', [\App\Http\Controllers\ReviewController::class, 'store'])->middleware('auth')->name('reviews.store');

// Admin panel auth routes
Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/login', [AdminAuthController::class, 'showLogin'])->middleware('guest')->name('login');
    Route::post('/login', [AdminAuthController::class, 'login'])->middleware('guest')->name('login.post');
    Route::post('/logout', [AdminAuthController::class, 'logout'])->middleware('auth')->name('logout');

    Route::middleware('admin.auth')->group(function () {
        Route::get('/', [AdminController::class, 'index'])->name('dashboard');

        // Menü yönetimi
        Route::get('/menus', [MenuController::class, 'index'])->name('menus.index');
        Route::post('/menus', [MenuController::class, 'storeMenu'])->name('menus.store');
        Route::post('/menus/{menu}/items', [MenuController::class, 'storeItem'])->name('menus.items.store');
        Route::put('/menu-items/{item}', [MenuController::class, 'updateItem'])->name('menus.items.update');
        Route::delete('/menu-items/{item}', [MenuController::class, 'destroyItem'])->name('menus.items.destroy');

        // Admin kullanıcıları
        Route::get('/users', [UserController::class, 'index'])->name('users.index');
        Route::post('/users', [UserController::class, 'store'])->name('users.store');
        Route::put('/users/{user}', [UserController::class, 'update'])->name('users.update');
        Route::delete('/users/{user}', [UserController::class, 'destroy'])->name('users.destroy');

        // Sipariş yönetimi
        Route::get('/orders', [\App\Http\Controllers\Admin\OrderManagementController::class, 'index'])->name('orders.index');
        Route::get('/orders/{order}', [\App\Http\Controllers\Admin\OrderManagementController::class, 'show'])->name('orders.show');
        Route::put('/orders/{order}/status', [\App\Http\Controllers\Admin\OrderManagementController::class, 'updateStatus'])->name('orders.updateStatus');

        // İade yönetimi
        Route::get('/returns', [\App\Http\Controllers\Admin\ReturnManagementController::class, 'index'])->name('returns.index');
        Route::get('/returns/{return}', [\App\Http\Controllers\Admin\ReturnManagementController::class, 'show'])->name('returns.show');
        Route::put('/returns/{return}/status', [\App\Http\Controllers\Admin\ReturnManagementController::class, 'updateStatus'])->name('returns.updateStatus');

        // Sayfa yönetimi
        Route::resource('pages', \App\Http\Controllers\Admin\PageManagementController::class);

        // Kategori yönetimi
        Route::resource('categories', \App\Http\Controllers\Admin\CategoryController::class);

        // Ürün yönetimi
        Route::resource('products', \App\Http\Controllers\Admin\ProductController::class);

        // Slider yönetimi
        Route::resource('sliders', \App\Http\Controllers\Admin\SliderController::class);
        Route::post('/sliders/{slider}/items', [\App\Http\Controllers\Admin\SliderController::class, 'addItem'])->name('sliders.addItem');
        Route::delete('/sliders/items/{item}', [\App\Http\Controllers\Admin\SliderController::class, 'removeItem'])->name('sliders.removeItem');
        Route::post('/sliders/items/order', [\App\Http\Controllers\Admin\SliderController::class, 'updateItemOrder'])->name('sliders.updateItemOrder');

        // Kampanya yönetimi
        Route::resource('campaigns', \App\Http\Controllers\Admin\CampaignController::class);

        // Site ayarları
        Route::get('/settings', [\App\Http\Controllers\Admin\SiteSettingsController::class, 'index'])->name('settings.index');
        Route::put('/settings', [\App\Http\Controllers\Admin\SiteSettingsController::class, 'update'])->name('settings.update');
    });
});

