@extends('layouts.app')
@section('content')
    <style>
        .products-wrapper { max-width: 1200px; margin: 0 auto; padding: 30px 16px; }
        
        .page-header { margin-bottom: 30px; }
        .page-header h1 { font-size: 32px; font-weight: 700; color: #333; margin-bottom: 10px; }
        .page-header .breadcrumb { font-size: 14px; color: #666; }
        .page-header .breadcrumb a { color: #73ae43; text-decoration: none; }
        .page-header .breadcrumb a:hover { text-decoration: underline; }
        
        .filters-sidebar { background: #f0f9f4; padding: 20px; border-radius: 12px; margin-bottom: 30px; }
        .filters-sidebar h3 { font-size: 18px; font-weight: 600; margin-bottom: 15px; color: #333; }
        .filter-group { margin-bottom: 20px; }
        .filter-group label { display: block; margin-bottom: 8px; font-weight: 600; color: #555; }
        .filter-group select, .filter-group input { width: 100%; padding: 10px; border: 1px solid #d1fae5; border-radius: 6px; background: #fff; }
        .filter-group .checkbox-label { display: flex; align-items: center; gap: 8px; font-weight: normal; }
        .filter-group .checkbox-label input { width: auto; }
        
        .products-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(220px, 1fr)); gap: 25px; }
        
        .product-card { background: #fff; border: 1px solid #e5e7eb; border-radius: 12px; overflow: hidden; transition: all 0.3s; position: relative; }
        .product-card:hover { transform: translateY(-5px); box-shadow: 0 8px 20px rgba(0,0,0,0.1); }
        
        .product-image-wrapper { position: relative; width: 100%; padding-top: 100%; background: #f9fafb; }
        .product-image-wrapper img { position: absolute; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover; }
        
        .product-badges { position: absolute; top: 10px; left: 10px; display: flex; flex-direction: column; gap: 8px; z-index: 2; }
        .badge-organic { background: #10b981; color: #fff; padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; display: flex; align-items: center; gap: 4px; }
        .badge-discount { background: #10b981; color: #fff; padding: 6px 10px; border-radius: 50%; font-size: 12px; font-weight: 700; width: 45px; height: 45px; display: flex; align-items: center; justify-content: center; }
        
        .product-info { padding: 15px; }
        .product-rating { display: flex; align-items: center; gap: 4px; margin-bottom: 8px; }
        .product-rating .stars { display: flex; gap: 2px; }
        .product-rating .star { font-size: 16px; color: #ddd; }
        .product-rating .star.filled { color: #ffc107; }
        .product-name { font-weight: 600; font-size: 14px; color: #333; margin-bottom: 8px; line-height: 1.4; min-height: 40px; }
        .product-farm { font-size: 12px; color: #666; margin-bottom: 8px; }
        .product-price-section { margin-bottom: 12px; }
        .product-price { font-weight: 700; color: #73ae43; font-size: 18px; }
        .product-old-price { font-size: 13px; color: #999; text-decoration: line-through; margin-top: 4px; }
        
        .product-actions { display: flex; gap: 8px; align-items: center; }
        .quantity-selector { display: flex; align-items: center; gap: 4px; border: 1px solid #e5e7eb; border-radius: 6px; padding: 2px 4px; flex-shrink: 0; }
        .quantity-btn { width: 24px; height: 24px; border: none; background: #f0f9f4; color: #73ae43; border-radius: 4px; cursor: pointer; font-size: 14px; display: flex; align-items: center; justify-content: center; padding: 0; }
        .quantity-btn:hover { background: #d1fae5; }
        .quantity-input { width: 32px; height: 24px; border: none; text-align: center; font-size: 12px; font-weight: 600; padding: 0; }
        .btn-add-cart { flex: 1; background: #ff6b35; color: #fff; padding: 10px; border-radius: 6px; font-size: 13px; font-weight: 600; text-align: center; border: none; cursor: pointer; transition: all 0.3s; }
        .btn-add-cart:hover { background: #e55a2b; transform: translateY(-2px); }
        .btn-in-cart { background: #10b981; }
        
        /* Tüm karta tıklanabilir yap */
        .product-card-link { text-decoration: none; color: inherit; display: block; }
        .product-card-link:hover { text-decoration: none; }
        .product-info { cursor: pointer; }
        .product-actions { cursor: default; }
        .product-actions * { cursor: pointer; }
        .product-actions button, .product-actions input { cursor: pointer; }
        
        .pagination-wrapper { margin-top: 40px; display: flex; justify-content: center; }
        
        @media (max-width: 768px) {
            .products-grid { grid-template-columns: repeat(auto-fill, minmax(160px, 1fr)); gap: 15px; }
            .product-name { min-height: auto; }
        }
    </style>

    <div class="products-wrapper">
        <div class="page-header">
            <h1>Ürünler</h1>
            <div class="breadcrumb">
                <a href="{{ route('home') }}">Ana Sayfa</a>
                <span>/</span>
                <span>Ürünler</span>
            </div>
        </div>

        <form method="GET" action="{{ route('product.index') }}" class="filters-sidebar">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px;">
                <div class="filter-group">
                    <label>Ara</label>
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Ürün ara...">
                </div>
                <div class="filter-group">
                    <label>Kategori</label>
                    <select name="category">
                        <option value="">Tüm Kategoriler</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="filter-group">
                    <label>Sırala</label>
                    <select name="sort">
                        <option value="order" {{ request('sort') == 'order' ? 'selected' : '' }}>Varsayılan</option>
                        <option value="price_asc" {{ request('sort') == 'price_asc' ? 'selected' : '' }}>Fiyat: Düşükten Yükseğe</option>
                        <option value="price_desc" {{ request('sort') == 'price_desc' ? 'selected' : '' }}>Fiyat: Yüksekten Düşüğe</option>
                        <option value="name" {{ request('sort') == 'name' ? 'selected' : '' }}>İsme Göre</option>
                        <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>Yeniden Eskiye</option>
                    </select>
                </div>
                <div class="filter-group">
                    <label style="margin-bottom: 10px;">Filtreler</label>
                    <div class="checkbox-label">
                        <input type="checkbox" name="organic" value="1" {{ request('organic') ? 'checked' : '' }}>
                        <span>Sadece Organik</span>
                    </div>
                    <div class="checkbox-label">
                        <input type="checkbox" name="featured" value="1" {{ request('featured') ? 'checked' : '' }}>
                        <span>Öne Çıkanlar</span>
                    </div>
                </div>
            </div>
            <button type="submit" style="margin-top: 15px; background: #73ae43; color: #fff; padding: 10px 20px; border: none; border-radius: 6px; cursor: pointer; font-weight: 600;">Filtrele</button>
            @if(request()->anyFilled(['search', 'category', 'organic', 'featured', 'sort']))
                <a href="{{ route('product.index') }}" style="margin-top: 10px; display: inline-block; color: #666; text-decoration: none; font-size: 14px;">Filtreleri Temizle</a>
            @endif
        </form>

        @if($products->count() > 0)
            <div class="products-grid">
                @foreach($products as $product)
                    <div class="product-card">
                        <a href="{{ route('product.show', $product->slug) }}" class="product-card-link">
                            <div class="product-image-wrapper">
                                <img src="{{ $product->image ? asset($product->image) : asset('images/placeholder.png') }}" alt="{{ $product->name }}">
                                <div class="product-badges">
                                    @if($product->is_organic)
                                        <div class="badge-organic">
                                            <span>🌿</span>
                                            <span>organik</span>
                                        </div>
                                    @endif
                                    @if($product->sale_price && $product->price > $product->sale_price)
                                        @php
                                            $discount = round((($product->price - $product->sale_price) / $product->price) * 100);
                                        @endphp
                                        <div class="badge-discount">%{{ $discount }}</div>
                                    @endif
                                </div>
                            </div>
                            <div class="product-info" onclick="event.stopPropagation();">
                            <div class="product-rating">
                                @php
                                    $avgRating = $product->average_rating ?? $product->rating;
                                    $fullStars = floor($avgRating);
                                @endphp
                                @for ($i = 0; $i < 5; $i++)
                                    @if ($i < $fullStars)
                                        <span class="star filled">★</span>
                                    @else
                                        <span class="star">☆</span>
                                    @endif
                                @endfor
                            </div>
                                <div class="product-name">{{ $product->name }}</div>
                                @if($product->farm_name || $product->origin)
                                    <div class="product-farm">
                                        @if($product->farm_name)
                                            {{ $product->farm_name }}
                                        @endif
                                        @if($product->origin)
                                            @if($product->farm_name) - @endif
                                            {{ $product->origin }}
                                        @endif
                                    </div>
                                @endif
                                <div class="product-price-section">
                                    <div class="product-price">
                                        @if($product->sale_price)
                                            {{ number_format($product->sale_price, 2, ',', '.') }} TL
                                        @else
                                            {{ number_format($product->price, 2, ',', '.') }} TL
                                        @endif
                                    </div>
                                    @if($product->sale_price && $product->price > $product->sale_price)
                                        <div class="product-old-price">{{ number_format($product->price, 2, ',', '.') }} TL</div>
                                    @endif
                                </div>
                            </div>
                        </a>
                        <div class="product-actions" onclick="event.stopPropagation();">
                            <div class="quantity-selector">
                                <button class="quantity-btn" onclick="event.stopPropagation(); decreaseQty({{ $product->id }})">-</button>
                                <input type="number" id="qty-{{ $product->id }}" class="quantity-input" value="1" min="1" max="{{ $product->stock_quantity > 0 ? $product->stock_quantity : 99 }}" onclick="event.stopPropagation();">
                                <button class="quantity-btn" onclick="event.stopPropagation(); increaseQty({{ $product->id }})">+</button>
                            </div>
                            <button class="btn-add-cart" onclick="event.stopPropagation(); addToCart({{ $product->id }})" {{ !$product->in_stock ? 'disabled' : '' }}>
                                {{ $product->in_stock ? 'SEPETE EKLE' : 'STOKTA YOK' }}
                            </button>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="pagination-wrapper">
                {{ $products->links() }}
            </div>
        @else
            <div style="text-align: center; padding: 60px 20px; color: #666;">
                <p style="font-size: 18px; margin-bottom: 10px;">Ürün bulunamadı</p>
                <p>Filtreleri değiştirerek tekrar deneyin.</p>
            </div>
        @endif
    </div>

    <script>
        function increaseQty(productId) {
            const input = document.getElementById('qty-' + productId);
            const max = parseInt(input.getAttribute('max')) || 99;
            const current = parseInt(input.value) || 1;
            if (current < max) {
                input.value = current + 1;
            }
        }

        function decreaseQty(productId) {
            const input = document.getElementById('qty-' + productId);
            const current = parseInt(input.value) || 1;
            if (current > 1) {
                input.value = current - 1;
            }
        }

        function addToCart(productId) {
            const quantity = document.getElementById('qty-' + productId).value;
            // Backend entegrasyonu için hazır - AJAX çağrısı yapılacak
            alert('Ürün sepete eklendi! (Backend entegrasyonu sonrası aktif olacak)');
        }
    </script>
@endsection

