@php
    $headerMenu = app(\App\Services\MenuService::class)->get('header');

    $renderMenu = function ($items) use (&$renderMenu) {
        if (!$items || $items->isEmpty()) {
            return;
        }
        echo '<ul class="menu-level">';
        foreach ($items as $item) {
            if (!$item->is_active) {
                continue;
            }
            $href = $item->url ?? ($item->route_name ? route($item->route_name, $item->route_params ?? []) : '#');
            $target = $item->target ?? '_self';
            echo '<li>';
            echo '<a href="'.e($href).'" target="'.e($target).'">'.e($item->title).'</a>';
            if ($item->children && $item->children->isNotEmpty()) {
                $renderMenu($item->children);
            }
            echo '</li>';
        }
        echo '</ul>';
    };
@endphp

<header class="dynamic-header">
    <div class="container">
        <div class="logo">
            <a href="{{ route('home') }}">{{ config('app.name', 'Site') }}</a>
        </div>
        <nav class="nav">
            @if($headerMenu && $headerMenu->items)
                {!! $renderMenu($headerMenu->items) !!}
            @endif
        </nav>
    </div>
</header>


