@extends('member.layout')
@section('member-content')
<h1 style="margin:0 0 30px;color:#414141;font-size:24px;font-weight:600;">Üye Paneli</h1>

<!-- İstatistikler -->
<div style="display:grid;grid-template-columns:repeat(auto-fit, minmax(200px, 1fr));gap:20px;margin-bottom:30px;">
    <div style="background:linear-gradient(135deg, #7db64f 0%, #6da443 100%);color:#fff;padding:20px;border-radius:8px;">
        <div style="font-size:32px;font-weight:bold;margin-bottom:8px;">{{ $stats['total_orders'] }}</div>
        <div style="font-size:14px;opacity:0.9;">Toplam Sipariş</div>
    </div>
    <div style="background:linear-gradient(135deg, #f39c12 0%, #e67e22 100%);color:#fff;padding:20px;border-radius:8px;">
        <div style="font-size:32px;font-weight:bold;margin-bottom:8px;">{{ $stats['pending_orders'] }}</div>
        <div style="font-size:14px;opacity:0.9;">Bekleyen Sipariş</div>
    </div>
    <div style="background:linear-gradient(135deg, #3498db 0%, #2980b9 100%);color:#fff;padding:20px;border-radius:8px;">
        <div style="font-size:32px;font-weight:bold;margin-bottom:8px;">{{ $stats['total_addresses'] }}</div>
        <div style="font-size:14px;opacity:0.9;">Kayıtlı Adres</div>
    </div>
    <div style="background:linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);color:#fff;padding:20px;border-radius:8px;">
        <div style="font-size:32px;font-weight:bold;margin-bottom:8px;">{{ $stats['total_favorites'] }}</div>
        <div style="font-size:14px;opacity:0.9;">Favori Ürün</div>
    </div>
</div>

<!-- Son Siparişler -->
<div>
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;">
        <h2 style="margin:0;color:#414141;font-size:20px;font-weight:600;">Son Siparişlerim</h2>
        <a href="{{ route('member.orders.index') }}" style="color:#7db64f;text-decoration:none;font-size:14px;">Tümünü Gör →</a>
    </div>

    @if($recent_orders->count() > 0)
        <div style="display:flex;flex-direction:column;gap:12px;">
            @foreach($recent_orders as $order)
                <div style="border:1px solid #e5e7eb;border-radius:8px;padding:16px;transition:box-shadow 0.3s;" onmouseover="this.style.boxShadow='0 4px 12px rgba(0,0,0,0.1)'" onmouseout="this.style.boxShadow='none'">
                    <div style="display:flex;justify-content:space-between;align-items:start;margin-bottom:12px;">
                        <div>
                            <div style="font-weight:600;color:#414141;margin-bottom:4px;">Sipariş #{{ $order->order_number }}</div>
                            <div style="font-size:12px;color:#666;">{{ $order->created_at->format('d.m.Y H:i') }}</div>
                        </div>
                        <div>
                            <span style="display:inline-block;padding:4px 12px;background:#f0f0f0;border-radius:4px;font-size:12px;font-weight:600;color:#414141;">
                                @if($order->status == 'pending') Beklemede
                                @elseif($order->status == 'confirmed') Onaylandı
                                @elseif($order->status == 'processing') Hazırlanıyor
                                @elseif($order->status == 'shipped') Kargoda
                                @elseif($order->status == 'delivered') Teslim Edildi
                                @elseif($order->status == 'cancelled') İptal Edildi
                                @endif
                            </span>
                        </div>
                    </div>
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div style="font-size:14px;color:#666;">
                            {{ $order->items->count() }} ürün • {{ number_format($order->total, 2) }} ₺
                        </div>
                        <a href="{{ route('member.orders.show', $order) }}" style="color:#7db64f;text-decoration:none;font-size:14px;font-weight:600;">Detaylar →</a>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div style="text-align:center;padding:40px;color:#666;">
            <div style="font-size:48px;margin-bottom:16px;">📦</div>
            <div style="font-size:16px;margin-bottom:8px;">Henüz siparişiniz bulunmuyor</div>
            <a href="{{ route('home') }}" style="color:#7db64f;text-decoration:none;font-weight:600;">Alışverişe Başla →</a>
        </div>
    @endif
</div>
@endsection

