@extends('layouts.app')
@section('content')
    <style>
        .campaign-wrapper { max-width: 1200px; margin: 0 auto; padding: 30px 16px; }
        
        .campaign-header { margin-bottom: 40px; }
        .campaign-breadcrumb { font-size: 14px; color: #666; margin-bottom: 15px; }
        .campaign-breadcrumb a { color: #73ae43; text-decoration: none; }
        .campaign-breadcrumb a:hover { text-decoration: underline; }
        
        .campaign-banner { width: 100%; height: 400px; object-fit: cover; border-radius: 12px; margin-bottom: 30px; }
        
        .campaign-main { display: grid; grid-template-columns: 2fr 1fr; gap: 30px; margin-bottom: 40px; }
        @media (max-width: 768px) {
            .campaign-main { grid-template-columns: 1fr; }
        }
        
        .campaign-content-section { background: #fff; padding: 30px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        .campaign-badge { display: inline-block; background: #ff6b35; color: #fff; padding: 8px 16px; border-radius: 20px; font-size: 14px; font-weight: 600; margin-bottom: 20px; }
        .campaign-title { font-size: 36px; font-weight: 700; color: #333; margin-bottom: 15px; }
        .campaign-discount { font-size: 48px; font-weight: 700; color: #73ae43; margin-bottom: 20px; }
        .campaign-description { font-size: 18px; color: #666; line-height: 1.8; margin-bottom: 30px; }
        .campaign-content { font-size: 16px; color: #333; line-height: 1.8; }
        .campaign-content h2, .campaign-content h3 { color: #73ae43; margin-top: 30px; margin-bottom: 15px; }
        .campaign-content p { margin-bottom: 15px; }
        .campaign-content ul, .campaign-content ol { margin-left: 20px; margin-bottom: 15px; }
        
        .campaign-sidebar { }
        .campaign-info-box { background: #f0f9f4; padding: 25px; border-radius: 12px; margin-bottom: 20px; }
        .campaign-info-box h3 { font-size: 18px; font-weight: 600; color: #333; margin-bottom: 15px; }
        .campaign-info-item { margin-bottom: 12px; }
        .campaign-info-item strong { color: #73ae43; }
        
        .campaign-button { display: block; background: #ff6b35; color: #fff; padding: 15px 30px; border-radius: 8px; text-align: center; text-decoration: none; font-weight: 600; font-size: 16px; transition: all 0.3s; margin-top: 20px; }
        .campaign-button:hover { background: #e55a2b; transform: translateY(-2px); }
        
        .other-campaigns { margin-top: 50px; }
        .other-campaigns h2 { font-size: 28px; font-weight: 700; color: #333; margin-bottom: 30px; }
        .other-campaigns-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(250px, 1fr)); gap: 25px; }
        .other-campaign-card { background: #fff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 8px rgba(0,0,0,0.1); transition: all 0.3s; }
        .other-campaign-card:hover { transform: translateY(-3px); box-shadow: 0 4px 12px rgba(0,0,0,0.15); }
        .other-campaign-card img { width: 100%; height: 150px; object-fit: cover; }
        .other-campaign-card-content { padding: 15px; }
        .other-campaign-card-title { font-size: 16px; font-weight: 600; color: #333; margin-bottom: 8px; }
        .other-campaign-card-link { color: #73ae43; text-decoration: none; font-size: 14px; font-weight: 600; }
        .other-campaign-card-link:hover { text-decoration: underline; }
    </style>

    <div class="campaign-wrapper">
        <div class="campaign-header">
            <div class="campaign-breadcrumb">
                <a href="{{ route('home') }}">Ana Sayfa</a> / 
                <a href="{{ route('campaigns.index') }}">Kampanyalar</a> / 
                {{ $campaign->title }}
            </div>
        </div>

        @if($campaign->banner_image)
            <img src="{{ asset($campaign->banner_image) }}" alt="{{ $campaign->title }}" class="campaign-banner">
        @endif

        <div class="campaign-main">
            <div class="campaign-content-section">
                @if($campaign->discount_percentage)
                    <span class="campaign-badge">%{{ $campaign->discount_percentage }} İndirim</span>
                @elseif($campaign->discount_amount)
                    <span class="campaign-badge">₺{{ number_format($campaign->discount_amount, 2) }} İndirim</span>
                @endif
                
                <h1 class="campaign-title">{{ $campaign->title }}</h1>
                
                @if($campaign->description)
                    <p class="campaign-description">{{ $campaign->description }}</p>
                @endif
                
                @if($campaign->content)
                    <div class="campaign-content">
                        {!! $campaign->content !!}
                    </div>
                @endif
                
                @if($campaign->button_link)
                    <a href="{{ $campaign->button_link }}" class="campaign-button">
                        {{ $campaign->button_text ?? 'Kampanyaya Git' }}
                    </a>
                @endif
            </div>
            
            <div class="campaign-sidebar">
                <div class="campaign-info-box">
                    <h3>Kampanya Bilgileri</h3>
                    
                    @if($campaign->discount_percentage)
                        <div class="campaign-info-item">
                            <strong>İndirim:</strong> %{{ $campaign->discount_percentage }}
                        </div>
                    @elseif($campaign->discount_amount)
                        <div class="campaign-info-item">
                            <strong>İndirim:</strong> ₺{{ number_format($campaign->discount_amount, 2) }}
                        </div>
                    @endif
                    
                    @if($campaign->start_date)
                        <div class="campaign-info-item">
                            <strong>Başlangıç:</strong> {{ $campaign->start_date->format('d.m.Y') }}
                        </div>
                    @endif
                    
                    @if($campaign->end_date)
                        <div class="campaign-info-item">
                            <strong>Bitiş:</strong> {{ $campaign->end_date->format('d.m.Y') }}
                        </div>
                    @endif
                    
                    <div class="campaign-info-item">
                        <strong>Durum:</strong> 
                        @if($campaign->isCurrentlyActive())
                            <span style="color: green;">Aktif</span>
                        @else
                            <span style="color: red;">Pasif</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        @if($otherCampaigns->count() > 0)
            <div class="other-campaigns">
                <h2>Diğer Kampanyalar</h2>
                <div class="other-campaigns-grid">
                    @foreach($otherCampaigns as $otherCampaign)
                        <div class="other-campaign-card">
                            @if($otherCampaign->image)
                                <img src="{{ asset($otherCampaign->image) }}" alt="{{ $otherCampaign->title }}">
                            @endif
                            <div class="other-campaign-card-content">
                                <h3 class="other-campaign-card-title">{{ $otherCampaign->title }}</h3>
                                <a href="{{ route('campaigns.show', $otherCampaign->slug) }}" class="other-campaign-card-link">Detayları Gör →</a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
@endsection

