@extends('admin.layout')

@section('content')
    <h1>Dashboard</h1>
    
    @php
        $totalOrders = \App\Models\Order::count();
        $pendingOrders = \App\Models\Order::where('status', 'pending')->count();
        $totalReturns = \App\Models\ReturnRequest::count();
        $pendingReturns = \App\Models\ReturnRequest::where('status', 'pending')->count();
        $totalUsers = \App\Models\User::where('is_admin', false)->count();
    @endphp

    <div class="grid grid-3 mt">
        <div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <h3 style="margin:0 0 10px;color:#666;font-size:14px;">Toplam Sipariş</h3>
            <div style="font-size:32px;font-weight:bold;color:#7db64f;">{{ $totalOrders }}</div>
        </div>
        <div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <h3 style="margin:0 0 10px;color:#666;font-size:14px;">Bekleyen Sipariş</h3>
            <div style="font-size:32px;font-weight:bold;color:#f39c12;">{{ $pendingOrders }}</div>
        </div>
        <div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <h3 style="margin:0 0 10px;color:#666;font-size:14px;">Toplam Üye</h3>
            <div style="font-size:32px;font-weight:bold;color:#3498db;">{{ $totalUsers }}</div>
        </div>
    </div>

    <div class="grid grid-2 mt">
        <div>
            <h3>Hızlı Bağlantılar</h3>
            <div class="flex mt" style="flex-wrap:wrap;gap:10px;">
                <a class="btn" href="{{ route('admin.orders.index') }}">Siparişler</a>
                <a class="btn" href="{{ route('admin.returns.index') }}">İade Talepleri</a>
                <a class="btn" href="{{ route('admin.menus.index') }}">Menü Yönetimi</a>
                <a class="btn" href="{{ route('admin.users.index') }}">Kullanıcılar</a>
                <a class="btn" href="{{ route('admin.pages.index') }}">Sayfa Yönetimi</a>
                <a class="btn" href="{{ route('admin.settings.index') }}">Site Ayarları</a>
                <a class="btn secondary" href="{{ url('/') }}" target="_blank">Siteyi Gör</a>
            </div>
        </div>
        <div>
            <h3>Bekleyen İşlemler</h3>
            <div class="mt">
                @if($pendingOrders > 0)
                    <p><a href="{{ route('admin.orders.index') }}?status=pending">{{ $pendingOrders }} bekleyen sipariş</a></p>
                @endif
                @if($pendingReturns > 0)
                    <p><a href="{{ route('admin.returns.index') }}?status=pending">{{ $pendingReturns }} bekleyen iade talebi</a></p>
                @endif
                @if($pendingOrders == 0 && $pendingReturns == 0)
                    <p style="color:#27ae60;">Tüm işlemler tamamlandı! 🎉</p>
                @endif
            </div>
        </div>
    </div>
@endsection

