@extends('admin.layout')
@section('content')
<h1>Kategori Düzenle: {{ $category->name }}</h1>

<form method="POST" action="{{ route('admin.categories.update', $category) }}" enctype="multipart/form-data" class="mt">
    @csrf
    @method('PUT')
    
    <div class="form-group">
        <label>Kategori Adı *</label>
        <input type="text" name="name" value="{{ old('name', $category->name) }}" required class="form-control" placeholder="Örn: Taze Meyve">
    </div>

    <div class="form-group">
        <label>Ana Kategori</label>
        <select name="parent_id" class="form-control">
            <option value="">Ana Kategori (Üst kategori yok)</option>
            @foreach($parentCategories as $parent)
                <option value="{{ $parent->id }}" {{ old('parent_id', $category->parent_id) == $parent->id ? 'selected' : '' }}>
                    {{ $parent->name }}
                </option>
            @endforeach
        </select>
        <small>Boş bırakılırsa ana kategori olarak kalır</small>
    </div>

    <div class="form-group">
        <label>İkon (Emoji veya Font Awesome class)</label>
        <input type="text" name="icon" value="{{ old('icon', $category->icon) }}" class="form-control" placeholder="🍎 veya fa fa-apple">
    </div>

    <div class="form-group">
        <label>Banner Görsel (500x500 px)</label>
        <input type="file" name="banner_image" accept="image/*" class="form-control">
        @if($category->banner_image)
            <div style="margin-top:10px;">
                <img src="{{ $category->banner_image }}" alt="Banner" style="max-width:200px;border:1px solid #e5e7eb;border-radius:4px;padding:5px;">
                <p style="margin:5px 0 0 0;font-size:12px;color:#666;">Mevcut banner görseli</p>
            </div>
        @endif
        <small>Yeni görsel yüklerseniz mevcut görsel değiştirilecektir. 500x500 piksel boyutunda olmalıdır.</small>
    </div>

    <div class="form-group">
        <label>Açıklama</label>
        <textarea name="description" rows="4" class="form-control" placeholder="Kategori hakkında kısa açıklama...">{{ old('description', $category->description) }}</textarea>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Sıra</label>
            <input type="number" name="order" value="{{ old('order', $category->order) }}" class="form-control" min="0">
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $category->is_active) ? 'checked' : '' }}>
                Aktif
            </label>
        </div>
    </div>

    <div class="flex mt">
        <button type="submit" class="btn">Güncelle</button>
        <a class="btn secondary" href="{{ route('admin.categories.index') }}">İptal</a>
    </div>
</form>
@endsection

