<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // E-ticaret ayarlarını ekle
        $settings = [
            // Favicon
            ['key' => 'site_favicon', 'value' => '/favicon.png', 'created_at' => now(), 'updated_at' => now()],
            
            // İletişim Bilgileri
            ['key' => 'contact_phone', 'value' => '02164610016', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'contact_email', 'value' => 'info@tazemasa.com', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'contact_address', 'value' => 'Esenevler Mah. Talatpaşa Cad. Akyıldız İş Merkezi No:20/8 Ümraniye – İSTANBUL', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'contact_working_hours', 'value' => 'Pazartesi - Cuma: 09:00 - 18:00', 'created_at' => now(), 'updated_at' => now()],
            
            // Sosyal Medya
            ['key' => 'social_facebook', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'social_instagram', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'social_twitter', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'social_youtube', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'social_linkedin', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            
            // Kargo Ayarları
            ['key' => 'shipping_free_threshold', 'value' => '200', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'shipping_cost', 'value' => '25', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'shipping_delivery_days', 'value' => '1-3', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'min_order_amount', 'value' => '50', 'created_at' => now(), 'updated_at' => now()],
            
            // Ödeme Ayarları
            ['key' => 'payment_methods', 'value' => 'Kredi Kartı, Havale/EFT, Kapıda Ödeme', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'bank_accounts', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            
            // İade ve İptal
            ['key' => 'return_policy_days', 'value' => '14', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'return_policy_text', 'value' => 'Ürünlerinizi teslimat tarihinden itibaren 14 gün içinde iade edebilirsiniz.', 'created_at' => now(), 'updated_at' => now()],
            
            // Analitik ve Takip
            ['key' => 'google_analytics_id', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'facebook_pixel_id', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'google_tag_manager_id', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            
            // E-posta Ayarları
            ['key' => 'email_from_name', 'value' => 'Tazemasa', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'email_from_address', 'value' => 'noreply@tazemasa.com', 'created_at' => now(), 'updated_at' => now()],
            
            // Para Puan Ayarları
            ['key' => 'para_puan_rate', 'value' => '1', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'para_puan_min_usage', 'value' => '10', 'created_at' => now(), 'updated_at' => now()],
            
            // Diğer Ayarlar
            ['key' => 'maintenance_mode', 'value' => '0', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'maintenance_message', 'value' => 'Sitemiz bakımda. Yakında tekrar hizmetinizdeyiz.', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'copyright_text', 'value' => '© 2025 Tazemasa. Tüm hakları saklıdır.', 'created_at' => now(), 'updated_at' => now()],
        ];
        
        foreach ($settings as $setting) {
            DB::table('site_settings')->updateOrInsert(
                ['key' => $setting['key']],
                $setting
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Geri alma işlemi - ayarları sil
        $keys = [
            'site_favicon', 'contact_phone', 'contact_email', 'contact_address', 'contact_working_hours',
            'social_facebook', 'social_instagram', 'social_twitter', 'social_youtube', 'social_linkedin',
            'shipping_free_threshold', 'shipping_cost', 'shipping_delivery_days', 'min_order_amount',
            'payment_methods', 'bank_accounts', 'return_policy_days', 'return_policy_text',
            'google_analytics_id', 'facebook_pixel_id', 'google_tag_manager_id',
            'email_from_name', 'email_from_address', 'para_puan_rate', 'para_puan_min_usage',
            'maintenance_mode', 'maintenance_message', 'copyright_text'
        ];
        
        DB::table('site_settings')->whereIn('key', $keys)->delete();
    }
};
