<?php

namespace App\Services;

use App\Models\Menu;
use Illuminate\Support\Facades\Cache;

class MenuService
{
    public function get(string $slug)
    {
        $cacheKey = "menus:{$slug}";

        return Cache::rememberForever($cacheKey, function () use ($slug) {
            return Menu::query()
                ->where('slug', $slug)
                ->where('is_active', true)
                ->with(['items' => function ($query) {
                    $query->where('is_active', true);
                }])
                ->first();
        });
    }

    public function flush(string $slug): void
    {
        Cache::forget("menus:{$slug}");
    }
}


