<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class ViewServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        // Share app name for dynamic header/footer defaults if needed.
        View::share('appName', config('app.name', 'Site'));
        
        // Share page meta data for all views
        View::composer('*', function ($view) {
            $siteName = \App\Models\SiteSetting::get('site_name', 'Tazemasa');
            $defaultTitle = \App\Models\SiteSetting::get('meta_title', 'tazemasa | Mutfak Alışverişi, Meyve, Sebze, Kahvaltılık ve Organik Ürünler');
            
            $pageMeta = [
                'title' => $defaultTitle,
                'description' => \App\Models\SiteSetting::get('meta_description', 'Doğadan geldiği gibi, saf, zehirsiz, katkısız, hayata saygılı ürünlerin adresi. İyi ye, iyi yaşa.'),
                'keywords' => \App\Models\SiteSetting::get('meta_keywords', 'tazemasa, Taze Masa'),
            ];
            
            // Eğer view'da $page değişkeni varsa, onu kullan
            $viewData = $view->getData();
            if (isset($viewData['page']) && $viewData['page'] instanceof \App\Models\Page) {
                $page = $viewData['page'];
                
                // Meta title varsa onu kullan, yoksa sayfa başlığı + site adı formatında
                if ($page->meta_title) {
                    $pageMeta['title'] = $page->meta_title;
                } else {
                    $pageMeta['title'] = $page->title . ' | ' . $siteName;
                }
                
                $pageMeta['description'] = $page->meta_description ?: $pageMeta['description'];
                $pageMeta['keywords'] = $page->meta_keywords ?: $pageMeta['keywords'];
            }
            
            $view->with('pageMeta', $pageMeta);
        });

        // Share categories for header navigation
        View::composer('partials.header_static_final', function ($view) {
            $categories = \App\Models\Category::whereNull('parent_id')
                ->where('is_active', true)
                ->with(['activeChildren' => function($query) {
                    $query->orderBy('order');
                }])
                ->orderBy('order')
                ->get();
            
            $view->with('headerCategories', $categories);
        });
    }
}

