<?php

namespace App\Http\Controllers;

use App\Models\Campaign;
use Illuminate\Http\Request;

class CampaignController extends Controller
{
    /**
     * Display a listing of active campaigns
     */
    public function index()
    {
        $campaigns = Campaign::active()
            ->orderBy('order')
            ->orderBy('created_at', 'desc')
            ->paginate(12);

        return view('campaigns.index', compact('campaigns'));
    }

    /**
     * Display the specified campaign
     */
    public function show($slug)
    {
        $campaign = Campaign::where('slug', $slug)
            ->where('is_active', true)
            ->firstOrFail();

        // Get other active campaigns
        $otherCampaigns = Campaign::where('id', '!=', $campaign->id)
            ->active()
            ->orderBy('order')
            ->limit(4)
            ->get();

        return view('campaigns.show', compact('campaign', 'otherCampaigns'));
    }
}
