
<?php $__env->startSection('content'); ?>
<h1>Yeni Ürün Ekle</h1>

<form method="POST" action="<?php echo e(route('admin.products.store')); ?>" enctype="multipart/form-data" class="mt">
    <?php echo csrf_field(); ?>
    
    <div class="form-row" style="display:grid;grid-template-columns:2fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Ürün Adı *</label>
            <input type="text" name="name" value="<?php echo e(old('name')); ?>" required class="form-control" placeholder="Örn: Organik Brokoli (500 gr)">
            <small>Ürün adı otomatik olarak slug'a dönüştürülecektir</small>
        </div>

        <div class="form-group">
            <label>Kategori</label>
            <select name="category_id" class="form-control">
                <option value="">Kategori Seçin</option>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                        <?php echo e($category->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>

    <div class="form-group">
        <label>Kısa Açıklama</label>
        <textarea name="description" rows="3" class="form-control" placeholder="Ürün hakkında kısa açıklama..."><?php echo e(old('description')); ?></textarea>
        <small>Ürün kartlarında görünecek kısa açıklama</small>
    </div>

    <div class="form-group">
        <label>Detaylı Açıklama</label>
        <textarea name="description_detail" rows="8" class="form-control" placeholder="Ürün hakkında detaylı açıklama, besin değerleri, tarifler vb..."><?php echo e(old('description_detail')); ?></textarea>
        <small>Ürün detay sayfasında "Açıklama" tab'ında görünecek detaylı içerik</small>
    </div>

    <div class="form-group">
        <label>Teslimat Bilgileri</label>
        <textarea name="delivery_info" rows="6" class="form-control" placeholder="Teslimat süresi, koşulları, muhafaza bilgileri vb..."><?php echo e(old('delivery_info')); ?></textarea>
        <small>Ürün detay sayfasında "TESLİMAT" tab'ında görünecek içerik</small>
    </div>

    <div class="form-group">
        <label>Sertifika Bilgileri</label>
        <textarea name="certificates_info" rows="6" class="form-control" placeholder="Organik sertifika bilgileri, sertifika numaraları vb..."><?php echo e(old('certificates_info')); ?></textarea>
        <small>Ürün detay sayfasında "SERTİFİKALAR" tab'ında görünecek içerik</small>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Fiyat (TL) *</label>
            <input type="number" name="price" value="<?php echo e(old('price')); ?>" required step="0.01" min="0" class="form-control" placeholder="99.95">
        </div>

        <div class="form-group">
            <label>İndirimli Fiyat (TL)</label>
            <input type="number" name="sale_price" value="<?php echo e(old('sale_price')); ?>" step="0.01" min="0" class="form-control" placeholder="79.95">
            <small>İndirimli fiyat, normal fiyattan küçük olmalıdır</small>
        </div>

        <div class="form-group">
            <label>SKU</label>
            <input type="text" name="sku" value="<?php echo e(old('sku')); ?>" class="form-control" placeholder="Ürün kodu">
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Ana Görsel</label>
            <input type="file" name="image" accept="image/*" class="form-control">
            <small>Ürünün ana görseli (JPEG, PNG, GIF, WebP - Max 2MB)</small>
        </div>

        <div class="form-group">
            <label>Galeri Görselleri</label>
            <input type="file" name="gallery[]" accept="image/*" multiple class="form-control">
            <small>Birden fazla görsel seçebilirsiniz</small>
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Çiftlik Adı</label>
            <input type="text" name="farm_name" value="<?php echo e(old('farm_name')); ?>" class="form-control" placeholder="Örn: Pulur Organik - Yalova">
        </div>

        <div class="form-group">
            <label>Menşei</label>
            <input type="text" name="origin" value="<?php echo e(old('origin')); ?>" class="form-control" placeholder="Örn: Mersin, Adana">
        </div>

        <div class="form-group">
            <label>Marka</label>
            <input type="text" name="brand" value="<?php echo e(old('brand')); ?>" class="form-control" placeholder="Marka adı">
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr 1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Ağırlık/Miktar</label>
            <input type="text" name="weight" value="<?php echo e(old('weight')); ?>" class="form-control" placeholder="Örn: 500 gr, 1 kg">
        </div>

        <div class="form-group">
            <label>Stok Miktarı</label>
            <input type="number" name="stock_quantity" value="<?php echo e(old('stock_quantity', 0)); ?>" min="0" class="form-control">
        </div>

        <div class="form-group">
            <label>Puan (0-5)</label>
            <input type="number" name="rating" value="<?php echo e(old('rating', 0)); ?>" min="0" max="5" class="form-control">
        </div>

        <div class="form-group">
            <label>Yorum Sayısı</label>
            <input type="number" name="review_count" value="<?php echo e(old('review_count', 0)); ?>" min="0" class="form-control">
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr 1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>
                <input type="checkbox" name="is_organic" value="1" <?php echo e(old('is_organic') ? 'checked' : ''); ?>>
                Organik Ürün
            </label>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_featured" value="1" <?php echo e(old('is_featured') ? 'checked' : ''); ?>>
                Öne Çıkan Ürün
            </label>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="in_stock" value="1" <?php echo e(old('in_stock', true) ? 'checked' : ''); ?>>
                Stokta Var
            </label>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                Aktif
            </label>
        </div>
    </div>

    <div class="form-group">
        <label>Sıra</label>
        <input type="number" name="order" value="<?php echo e(old('order', 0)); ?>" class="form-control" min="0">
        <small>Ürünlerin sıralaması (küçükten büyüğe)</small>
    </div>

    <div class="flex mt">
        <button type="submit" class="btn">Kaydet</button>
        <a class="btn secondary" href="<?php echo e(route('admin.products.index')); ?>">İptal</a>
    </div>
</form>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/products/create.blade.php ENDPATH**/ ?>