

<?php $__env->startSection('content'); ?>
    <h1>Admin Kullanıcıları</h1>
    <p>Yeni admin ekleyebilir, mevcutların bilgilerini güncelleyebilir, gerekirse silebilirsiniz.</p>

    <div class="grid grid-2 mt">
        <div>
            <h3>Yeni Admin Ekle</h3>
            <form method="POST" action="<?php echo e(route('admin.users.store')); ?>">
                <?php echo csrf_field(); ?>
                <input name="name" placeholder="Ad Soyad" required>
                <input name="email" type="email" placeholder="E-posta" required>
                <input name="password" type="password" placeholder="Şifre (min 8 karakter)" required>
                <button class="btn" type="submit">Oluştur</button>
            </form>
        </div>
        <div>
            <h3>Bilgi</h3>
            <p>Varsayılan admin: <code>admin@example.com / Admin123!</code> (seed ile eklenir). Giriş yaptıktan sonra yeni bir admin oluşturup varsayılan hesabı silebilirsiniz.</p>
        </div>
    </div>

    <div class="mt">
        <h3>Mevcut Adminler</h3>
        <?php if($admins->isEmpty()): ?>
            <p>Henüz admin yok.</p>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>İsim</th>
                        <th>E-posta</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($admin->id); ?></td>
                            <td><?php echo e($admin->name); ?></td>
                            <td><?php echo e($admin->email); ?></td>
                            <td class="flex">
                                <form method="POST" action="<?php echo e(route('admin.users.update', $admin)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <input type="hidden" name="name" value="<?php echo e($admin->name); ?>">
                                    <input type="hidden" name="email" value="<?php echo e($admin->email); ?>">
                                    <input type="password" name="password" placeholder="Yeni şifre (opsiyonel)">
                                    <button class="btn secondary" type="submit">Güncelle</button>
                                </form>
                                <?php if(auth()->id() !== $admin->id): ?>
                                    <form method="POST" action="<?php echo e(route('admin.users.destroy', $admin)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn danger" type="submit" onclick="return confirm('Silinsin mi?')">Sil</button>
                                    </form>
                                <?php else: ?>
                                    <span class="badge">Kendi hesabın</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/users/index.blade.php ENDPATH**/ ?>