

<?php $__env->startSection('content'); ?>
    <h1>Dashboard</h1>
    
    <?php
        $totalOrders = \App\Models\Order::count();
        $pendingOrders = \App\Models\Order::where('status', 'pending')->count();
        $totalReturns = \App\Models\ReturnRequest::count();
        $pendingReturns = \App\Models\ReturnRequest::where('status', 'pending')->count();
        $totalUsers = \App\Models\User::where('is_admin', false)->count();
    ?>

    <div class="grid grid-3 mt">
        <div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <h3 style="margin:0 0 10px;color:#666;font-size:14px;">Toplam Sipariş</h3>
            <div style="font-size:32px;font-weight:bold;color:#7db64f;"><?php echo e($totalOrders); ?></div>
        </div>
        <div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <h3 style="margin:0 0 10px;color:#666;font-size:14px;">Bekleyen Sipariş</h3>
            <div style="font-size:32px;font-weight:bold;color:#f39c12;"><?php echo e($pendingOrders); ?></div>
        </div>
        <div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <h3 style="margin:0 0 10px;color:#666;font-size:14px;">Toplam Üye</h3>
            <div style="font-size:32px;font-weight:bold;color:#3498db;"><?php echo e($totalUsers); ?></div>
        </div>
    </div>

    <div class="grid grid-2 mt">
        <div>
            <h3>Hızlı Bağlantılar</h3>
            <div class="flex mt" style="flex-wrap:wrap;gap:10px;">
                <a class="btn" href="<?php echo e(route('admin.orders.index')); ?>">Siparişler</a>
                <a class="btn" href="<?php echo e(route('admin.returns.index')); ?>">İade Talepleri</a>
                <a class="btn" href="<?php echo e(route('admin.menus.index')); ?>">Menü Yönetimi</a>
                <a class="btn" href="<?php echo e(route('admin.users.index')); ?>">Kullanıcılar</a>
                <a class="btn" href="<?php echo e(route('admin.pages.index')); ?>">Sayfa Yönetimi</a>
                <a class="btn" href="<?php echo e(route('admin.settings.index')); ?>">Site Ayarları</a>
                <a class="btn secondary" href="<?php echo e(url('/')); ?>" target="_blank">Siteyi Gör</a>
            </div>
        </div>
        <div>
            <h3>Bekleyen İşlemler</h3>
            <div class="mt">
                <?php if($pendingOrders > 0): ?>
                    <p><a href="<?php echo e(route('admin.orders.index')); ?>?status=pending"><?php echo e($pendingOrders); ?> bekleyen sipariş</a></p>
                <?php endif; ?>
                <?php if($pendingReturns > 0): ?>
                    <p><a href="<?php echo e(route('admin.returns.index')); ?>?status=pending"><?php echo e($pendingReturns); ?> bekleyen iade talebi</a></p>
                <?php endif; ?>
                <?php if($pendingOrders == 0 && $pendingReturns == 0): ?>
                    <p style="color:#27ae60;">Tüm işlemler tamamlandı! 🎉</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>