<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin | <?php echo e(config('app.name', 'Site')); ?></title>
    <style>
        body { font-family: Arial, sans-serif; margin:0; padding:0; background:#f5f6fa; color:#333; }
        header { background:#111827; color:#fff; padding:16px 24px; display:flex; align-items:center; justify-content:space-between; }
        header a { color:#e5e7eb; margin-right:16px; text-decoration:none; }
        header a:hover { color:#fff; }
        .container { max-width: 1180px; margin: 24px auto; background:#fff; padding:24px; border-radius:8px; box-shadow:0 6px 20px rgba(0,0,0,0.06); }
        h1,h2,h3 { margin-top:0; }
        .nav-links { display:flex; gap:16px; align-items:center; }
        .btn { display:inline-block; padding:10px 14px; border-radius:6px; border:1px solid #111827; background:#111827; color:#fff; text-decoration:none; font-size:14px; }
        .btn.secondary { background:#fff; color:#111827; }
        .btn.danger { background:#b91c1c; border-color:#b91c1c; color:#fff; }
        .grid { display:grid; gap:16px; }
        .grid-2 { grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); }
        form { display:grid; gap:12px; }
        input, select, textarea { width:100%; padding:10px; border:1px solid #d1d5db; border-radius:6px; }
        table { width:100%; border-collapse:collapse; margin-top:12px; }
        th, td { padding:10px; border-bottom:1px solid #e5e7eb; text-align:left; }
        .badge { display:inline-block; padding:4px 8px; border-radius:12px; font-size:12px; background:#e5e7eb; }
        .flex { display:flex; gap:8px; align-items:center; }
        .mt { margin-top:16px; }
        .alert { padding:12px 14px; border-radius:6px; background:#ecfdf3; color:#065f46; border:1px solid #bbf7d0; margin-bottom:16px; }
        .alert.error { background:#fef2f2; color:#991b1b; border-color:#fecdd3; }
        small { color:#6b7280; }
    </style>
</head>
<body>
    <header>
        <div class="nav-links">
            <strong>Admin | <?php echo e(config('app.name', 'Site')); ?></strong>
            <a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
            <a href="<?php echo e(route('admin.products.index')); ?>">Ürünler</a>
            <a href="<?php echo e(route('admin.categories.index')); ?>">Kategoriler</a>
            <a href="<?php echo e(route('admin.sliders.index')); ?>">Slider'lar</a>
            <a href="<?php echo e(route('admin.menus.index')); ?>">Menüler</a>
            <a href="<?php echo e(route('admin.users.index')); ?>">Admin Kullanıcıları</a>
            <a href="<?php echo e(route('admin.pages.index')); ?>">Sayfalar</a>
            <a href="<?php echo e(route('admin.settings.index')); ?>">Site Ayarları</a>
        </div>
        <div>
            <form method="POST" action="<?php echo e(route('admin.logout')); ?>">
                <?php echo csrf_field(); ?>
                <button class="btn secondary" type="submit">Çıkış</button>
            </form>
        </div>
    </header>

    <div class="container">
        <?php if(session('status')): ?>
            <div class="alert"><?php echo e(session('status')); ?></div>
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <div class="alert error">
                <strong>Hata:</strong>
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
    </div>
</body>
</html>

<?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/layout.blade.php ENDPATH**/ ?>