<header class="tm-header">
    <div class="tm-topbar">
        <div class="tm-container tm-topbar-inner">
            <div class="tm-top-links">
                <a href="<?php echo e(route('pages.para-puan-nedir')); ?>">Para Puan Nedir?</a>
                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('member.para-puanlarim')); ?>">Para Puanlarım</a>
                <?php else: ?>
                    <a href="<?php echo e(route('auth.login')); ?>">Para Puanlarım</a>
                <?php endif; ?>
                <a href="<?php echo e(route('pages.organik-sertifikalar')); ?>">Organik Sertifikalar</a>
                <a href="<?php echo e(route('pages.siparis-takip')); ?>">Siparişin Nerede</a>
                <a href="<?php echo e(route('pages.sevkiyat')); ?>">Sevkiyat</a>
                <a href="<?php echo e(route('pages.yardim')); ?>">Yardım</a>
            </div>
            <div class="tm-repeat">
                <?php if(auth()->guard()->check()): ?>
                    <a class="tm-repeat-btn" href="<?php echo e(route('member.orders.index')); ?>">Sipariş Tekrarı</a>
                <?php else: ?>
                    <a class="tm-repeat-btn" href="<?php echo e(route('auth.login')); ?>">Sipariş Tekrarı</a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="tm-mainbar">
        <div class="tm-container tm-mainbar-inner">
            <button class="tm-menu-btn" aria-label="Menü" onclick="document.body.classList.toggle('tm-menu-open');">☰</button>
            <a class="tm-logo" href="<?php echo e(url('/')); ?>">
                <img src="<?php echo e(\App\Models\SiteSetting::get('site_logo', '/logo.png')); ?>" alt="<?php echo e(\App\Models\SiteSetting::get('site_name', 'Tazemasa')); ?>" style="display:block;max-width:100%;height:auto;">
            </a>
            <form class="tm-search" action="<?php echo e(route('product.search')); ?>" method="GET">
                <input type="text" name="q" placeholder="Arama" value="<?php echo e(request('q')); ?>">
                <button type="submit" aria-label="Ara">🔍</button>
            </form>
            <div class="tm-actions">
                <a href="<?php echo e(route('campaigns.index')); ?>"><span class="tm-icon-green">🔔</span><small>Kampanyalar</small></a>
                <?php if(auth()->guard()->check()): ?>
                    <?php if(!Auth::user()->is_admin): ?>
                        <div class="tm-user-menu-wrapper" style="position:relative;">
                            <a href="#" class="tm-user-menu" style="position:relative;display:flex;flex-direction:column;align-items:center;text-decoration:none;color:#3f3f3f;">
                                <span class="tm-icon-green">👤</span>
                                <small>Üye Paneli</small>
                            </a>
                            <div class="tm-user-dropdown">
                                <a href="<?php echo e(route('member.dashboard')); ?>">📊 Üye Paneli</a>
                                <a href="<?php echo e(route('member.orders.index')); ?>">📦 Siparişlerim</a>
                                <a href="<?php echo e(route('member.addresses.index')); ?>">📍 Adreslerim</a>
                                <a href="<?php echo e(route('member.favorites.index')); ?>">💚 Favorilerim</a>
                                <a href="<?php echo e(route('member.returns.index')); ?>">↩️ İade/İptal</a>
                                <a href="<?php echo e(route('profile.index')); ?>">⚙️ Hesap Ayarları</a>
                                <form method="POST" action="<?php echo e(route('auth.logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit">🚪 Çıkış Yap</button>
                                </form>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <a href="<?php echo e(route('auth.login')); ?>"><span class="tm-icon-green tm-user-icon">👤</span><small>Üye Girişi</small></a>
                <?php endif; ?>
                <a href="#"><span class="tm-icon-green">💚</span><small>Favorilerim</small></a>
                <a href="#"><span class="tm-icon-green">🛒</span><small>Sepetim</small></a>
            </div>
        </div>
    </div>

    <nav class="tm-categories">
        <div class="tm-categories-wrapper">
        <div class="tm-container tm-cats-inner">
            <?php if(isset($headerCategories) && $headerCategories->count() > 0): ?>
                <?php $__currentLoopData = $headerCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="tm-cat-item" data-category-id="<?php echo e($category->id); ?>">
                        <a href="<?php echo e(route('category.show', $category->slug)); ?>">
                            <span class="tm-cat-icon"><?php echo e($category->icon ?? '📦'); ?></span>
                            <span class="tm-cat-text"><?php echo e($category->name); ?></span>
                        </a>
                        <?php if($category->activeChildren->count() > 0 || $category->banner_image): ?>
                            <div class="tm-cat-dropdown">
                                <div class="tm-cat-dropdown-content">
                                    <?php if($category->activeChildren->count() > 0): ?>
                                        <div class="tm-cat-dropdown-left">
                                            <?php
                                                $columnCount = $category->banner_image ? 2 : 3;
                                                $chunks = $category->activeChildren->chunk(ceil($category->activeChildren->count() / $columnCount));
                                            ?>
                                            <?php $__currentLoopData = $chunks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="tm-cat-dropdown-column">
                                                    <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a href="<?php echo e(route('category.show', $child->slug)); ?>" class="tm-cat-dropdown-link">
                                                            <span class="tm-cat-dropdown-icon"><?php echo e($child->icon ?? '📦'); ?></span>
                                                            <span><?php echo e($child->name); ?></span>
                                                        </a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($category->banner_image): ?>
                                        <div class="tm-cat-dropdown-right">
                                            <a href="<?php echo e(route('category.show', $category->slug)); ?>" class="tm-cat-banner-link">
                                                <img src="<?php echo e(asset($category->banner_image)); ?>" alt="<?php echo e($category->name); ?>" class="tm-cat-banner" onerror="this.style.display='none';">
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                
                <a href="#"><span class="tm-cat-icon">🍎</span><span class="tm-cat-text">Taze Meyve</span></a>
                <a href="#"><span class="tm-cat-icon">🌶️</span><span class="tm-cat-text">Taze Sebze</span></a>
                <a href="#"><span class="tm-cat-icon">🧀</span><span class="tm-cat-text">Kahvaltılık Ürünler</span></a>
            <?php endif; ?>
        </div>
        </div>
    </nav>
</header>

<style>
    * { margin:0; padding:0; box-sizing:border-box; }
    html { margin:0 !important; padding:0 !important; }
    body { margin:0 !important; padding:0 !important; }
    body#bodyGlobal { margin:0 !important; padding:0 !important; }
    html#htmlGlobal { margin:0 !important; padding:0 !important; }
    .tm-container { max-width: 1180px; margin: 0 auto; padding: 0 16px; box-sizing: border-box; }
    .tm-header { font-family: 'Helvetica Neue', Arial, sans-serif; color: #414141; margin:0; padding:0; }
    .tm-topbar { background:#444; color:#fff; font-size:13px; margin:0; padding:0; position:relative; }
    .tm-topbar-inner { display:flex; justify-content:space-between; align-items:center; min-height:38px; }
    .tm-top-links { display:flex; gap:18px; flex-wrap:wrap; }
    .tm-top-links a { color:#fff; text-decoration:none; }
    .tm-repeat-btn { background:#5d5d5d; color:#fff; padding:8px 12px; border-radius:4px; text-decoration:none; font-weight:600; }
    .tm-repeat-btn:hover { background:#4b4b4b; }

    .tm-mainbar { background:#fff; border-bottom:1px solid #e5e7eb; }
    .tm-mainbar-inner { display:flex; align-items:center; gap:24px; padding:14px 0; }
    .tm-logo { display:block; line-height:0; }
    .tm-logo img { height:54px; display:block; max-width:100%; object-fit:contain; }
    .tm-search { flex:1; display:flex; border:2px solid #85ba5c; border-radius:4px; overflow:hidden; }
    .tm-search input { flex:1; padding:10px 12px; border:none; outline:none; font-size:15px; }
    .tm-search button { background:#7db64f; border:none; width:48px; color:#fff; font-size:18px; cursor:pointer; }
    .tm-search button:hover { background:#6da443; }
    .tm-actions { display:flex; gap:18px; align-items:center; }
    .tm-actions a { display:flex; flex-direction:column; align-items:center; text-decoration:none; color:#3f3f3f; font-size:13px; position:relative; }
    .tm-actions span { font-size:20px; }
    /* Yeşil ikonlar için özel stil */
    .tm-icon-green { 
        font-size: 20px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 28px;
        height: 28px;
        background: #7db64f;
        border-radius: 6px;
        color: #fff;
        line-height: 1;
    }
    .tm-actions a {
        gap: 4px;
    }
    .tm-menu-btn { display:none; background:none; border:none; font-size:24px; cursor:pointer; padding:4px 8px; }
    .tm-user-menu-wrapper { 
        position:relative; 
        cursor:pointer; 
    }
    .tm-user-menu { 
        cursor:pointer; 
    }
    .tm-user-dropdown {
        display:none;
        position:absolute;
        top:calc(100% + 8px);
        right:0;
        background:#fff;
        box-shadow:0 2px 8px rgba(0,0,0,0.1);
        border-radius:4px;
        min-width:180px;
        z-index:9999;
        overflow:hidden;
        border:1px solid #e5e7eb;
        font-family:'Helvetica Neue', Arial, sans-serif;
        font-size:13px;
        padding:4px 0;
    }
    .tm-user-menu-wrapper:hover .tm-user-dropdown,
    .tm-user-menu-wrapper.active .tm-user-dropdown,
    .tm-user-dropdown.tm-dropdown-open { 
        display:block;
    }
    .tm-user-dropdown a {
        display:block;
        padding:10px 16px;
        text-decoration:none;
        color:#3f3f3f;
        font-size:13px;
        transition:background 0.15s;
        border-bottom:1px solid #f5f5f5;
    }
    .tm-user-dropdown a:last-of-type {
        border-bottom:none;
    }
    .tm-user-dropdown a:hover {
        background:#f7f7f7;
        color:#69a338;
    }
    .tm-user-dropdown form {
        margin:0;
        border-top:1px solid #f5f5f5;
    }
    .tm-user-dropdown button {
        width:100%;
        text-align:left;
        padding:10px 16px;
        background:none;
        border:none;
        color:#e74c3c;
        cursor:pointer;
        font-size:13px;
        font-family:'Helvetica Neue', Arial, sans-serif;
        transition:background 0.15s;
    }
    .tm-user-dropdown button:hover {
        background:#f7f7f7;
    }
    @keyframes slideDown {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    /* Dropdown dışına tıklanınca kapat */
    @media (max-width: 960px) {
        .tm-user-dropdown { display:none !important; }
        .tm-user-dropdown.tm-dropdown-open { display:block !important; }
    }
    .tm-bottom-nav { 
        display:none !important; 
    }

    .tm-categories { background:#fff; border-bottom:1px solid #e5e7eb; position:relative; z-index:100; }
    .tm-categories-wrapper { position:relative; width:100%; }
    .tm-cats-inner { display:grid; grid-auto-flow:column; grid-auto-columns:1fr; gap:0; }
    .tm-cat-item { position:relative; }
    .tm-cats-inner a, .tm-cat-item > a { 
        display:flex;
        flex-direction:column;
        align-items:center;
        justify-content:center;
        text-align:center; 
        padding:14px 10px; 
        color:#3f3f3f; 
        text-decoration:none; 
        font-weight:600; 
        font-size:12px; 
        border-right:1px solid #f0f0f0;
        gap:6px;
    }
    .tm-cat-item:last-child > a { border-right:none; }
    .tm-cats-inner a:hover, .tm-cat-item:hover > a { color:#69a338; background:#f9fafb; }
    .tm-cat-icon {
        font-size:24px;
        line-height:1;
        display:block;
    }
    .tm-cat-text {
        font-size:11px;
        line-height:1.2;
        text-transform:uppercase;
    }

    /* Category Dropdown */
    .tm-cat-dropdown {
        display:none;
        position:absolute;
        top:100%;
        left:0;
        width:auto;
        min-width:600px;
        max-width:900px;
        background:#ffffff !important;
        box-shadow:0 4px 12px rgba(0,0,0,0.1);
        border-top:2px solid #73ae43;
        z-index:10000;
        padding:0;
        margin-top:0;
        opacity:1 !important;
        visibility:visible !important;
        margin-left:0;
        max-height:350px;
        overflow-y:auto;
    }
    .tm-cat-item {
        position:relative;
    }
    .tm-categories {
        position:relative;
    }
    .tm-cats-inner {
        position:relative;
    }
    .tm-cat-item:hover .tm-cat-dropdown {
        display:block !important;
        animation:slideDown 0.2s ease;
    }
    @media (max-width: 768px) {
        .tm-cat-dropdown {
            max-height:400px;
            min-width:100%;
            max-width:100%;
        }
        .tm-cat-dropdown-right {
            width:100%;
            min-width:100%;
            max-width:100%;
            border-left:none;
            border-top:1px solid #e5e7eb;
        }
        .tm-cat-dropdown-content {
            flex-direction:column;
        }
    }
    .tm-cat-dropdown-content {
        display:flex !important;
        width:100%;
        margin:0;
        padding:0;
        background:#ffffff !important;
        min-height:auto;
    }
    .tm-cat-dropdown-left {
        flex:1;
        display:flex;
        padding:15px;
        gap:20px;
        background:#fff;
        min-width:0;
        flex-wrap:nowrap;
        max-width:500px;
    }
    .tm-cat-dropdown-column {
        display:flex;
        flex-direction:column;
        gap:4px;
        min-width:160px;
        flex-shrink:0;
    }
    .tm-cat-dropdown-link {
        display:flex;
        align-items:center;
        gap:6px;
        padding:6px 8px;
        color:#3f3f3f !important;
        text-decoration:none;
        font-size:12px;
        border-radius:3px;
        transition:background 0.2s;
        background:transparent;
        white-space:nowrap;
    }
    .tm-cat-dropdown-link:hover {
        background:#f0f9f4 !important;
        color:#73ae43 !important;
    }
    .tm-cat-dropdown-icon {
        font-size:14px;
        width:18px;
        text-align:center;
        display:inline-block;
        flex-shrink:0;
    }
    .tm-cat-dropdown-right {
        width:300px;
        min-width:300px;
        max-width:300px;
        padding:15px;
        background:#f9fafb;
        border-left:1px solid #e5e7eb;
        display:flex !important;
        align-items:center;
        justify-content:center;
        flex-shrink:0;
    }
    .tm-cat-banner-link {
        display:block !important;
        width:100% !important;
        height:100% !important;
        text-align:center;
        line-height:0;
    }
    .tm-cat-banner {
        width:100% !important;
        height:auto !important;
        max-width:100% !important;
        max-height:280px !important;
        object-fit:contain !important;
        object-position:center center !important;
        border-radius:6px;
        display:block !important;
        visibility:visible !important;
        opacity:1 !important;
        margin:0 auto;
    }
    @keyframes slideDown {
        from {
            opacity:0;
            transform:translateY(-10px);
        }
        to {
            opacity:1;
            transform:translateY(0);
        }
    }

    /* Drawer */
    .tm-mobile-drawer {
        position:fixed;
        top:0; left:0; bottom:0;
        width:82%;
        max-width:320px;
        background:#fff;
        box-shadow:2px 0 18px rgba(0,0,0,0.18);
        transform:translateX(-100%);
        transition:transform 0.28s ease;
        z-index:120;
        display:flex;
        flex-direction:column;
    }
    .tm-drawer-header {
        display:flex;
        align-items:center;
        justify-content:space-between;
        padding:14px 16px;
        background:#71aa2d;
        color:#fff;
        font-weight:700;
    }
    .tm-drawer-header button {
        background:none;
        border:none;
        color:#fff;
        font-size:18px;
        cursor:pointer;
    }
    .tm-drawer-list {
        padding:10px 0;
        overflow-y:auto;
        flex:1;
    }
    .tm-drawer-list a {
        display:flex;
        align-items:center;
        gap:10px;
        padding:12px 16px;
        text-decoration:none;
        color:#2f2f2f;
        border-bottom:1px solid #f0f0f0;
        font-weight:600;
    }
    .tm-drawer-list a:hover { background:#f7f7f7; }
    .tm-overlay {
        position:fixed;
        inset:0;
        background:rgba(0,0,0,0.35);
        opacity:0;
        pointer-events:none;
        transition:opacity 0.2s ease;
        z-index:110;
    }
    body.tm-menu-open .tm-mobile-drawer { transform:translateX(0); }
    body.tm-menu-open .tm-overlay { opacity:1; pointer-events:auto; }

    @media (max-width: 960px) {
        .tm-topbar { display:none; }
        .tm-mainbar { border-bottom:none; }
        .tm-mainbar-inner { flex-wrap:wrap; gap:12px; padding:12px 0; }
        .tm-menu-btn { display:block; }
        .tm-logo { order:2; margin:0 auto; }
        .tm-logo img { height:48px; }
        .tm-search { order:3; width:100%; }
        .tm-actions { order:4; width:100%; justify-content:space-around; }
        .tm-actions a { font-size:12px; flex-direction:row; gap:6px; }
        .tm-actions span { font-size:18px; }
        .tm-categories { display:none; }
        body { padding-bottom:68px; }
        .tm-user-dropdown { right:0 !important; left:auto !important; min-width:200px !important; }
        .tm-user-menu-wrapper:hover .tm-user-dropdown { display:none !important; }
        .tm-user-menu-wrapper.active .tm-user-dropdown { display:block !important; }
        .tm-bottom-nav {
            display:flex !important;
            position:fixed;
            bottom:0; left:0; right:0;
            background:#71aa2d;
            color:#fff;
            height:62px;
            border-top:1px solid rgba(0,0,0,0.08);
            z-index:50;
        }
        .tm-bottom-nav a {
            flex:1;
            text-align:center;
            text-decoration:none;
            color:#fff;
            display:flex;
            flex-direction:column;
            align-items:center;
            justify-content:center;
            font-size:12px;
            gap:4px;
        }
        .tm-bottom-nav .tm-icon { font-size:18px; line-height:1; }
    }
</style>

<div class="tm-mobile-drawer">
    <div class="tm-drawer-header">
        <span>Kategoriler</span>
        <button aria-label="Kapat" onclick="document.body.classList.remove('tm-menu-open');">✕</button>
    </div>
    <div class="tm-drawer-list">
        <a href="#"><span style="font-size:20px;margin-right:8px;">🍎</span>Taze Meyve</a>
        <a href="#"><span style="font-size:20px;margin-right:8px;">🌶️</span>Taze Sebze</a>
        <a href="#"><span style="font-size:20px;margin-right:8px;">🧀</span>Kahvaltılık Ürünler</a>
        <a href="#"><span style="font-size:20px;margin-right:8px;">🥖</span>Ekmek &amp; Unlu Mamüller</a>
        <a href="#"><span style="font-size:20px;margin-right:8px;">🫒</span>Zeytin &amp; Zeytinyağı</a>
        <a href="#"><span style="font-size:20px;margin-right:8px;">🍅</span>Salça &amp; Soslar</a>
        <a href="#"><span style="font-size:20px;margin-right:8px;">🌾</span>Kuru Gıdalar</a>
        <a href="#"><span style="font-size:20px;margin-right:8px;">🍗</span>Et, Tavuk ve Balık Ürünleri</a>
        <a href="#"><span style="font-size:20px;margin-right:8px;">🛒</span>Taze Sepetler</a>
        <a href="#"><span style="font-size:20px;margin-right:8px;">🌿</span>Organik Ürünler</a>
        <a href="#"><span style="font-size:20px;margin-right:8px;">🧴</span>Temizlik ve Kişisel Bakım</a>
    </div>
</div>

<?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/partials/header_static_final.blade.php ENDPATH**/ ?>