
<?php $__env->startSection('content'); ?>
<h1>Kategori Yönetimi</h1>
<div class="mt">
    <a class="btn" href="<?php echo e(route('admin.categories.create')); ?>">Yeni Kategori Ekle</a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success mt"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger mt">
        <ul style="margin:0;padding-left:20px;">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<div class="mt" style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:20px;">
    <h2 style="margin:0 0 20px 0;font-size:18px;">Ana Kategoriler</h2>
    
    <?php $__currentLoopData = $categories->whereNull('parent_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parentCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div style="border:1px solid #e5e7eb;border-radius:6px;padding:15px;margin-bottom:15px;background:#f9fafb;">
            <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:10px;">
                <div style="display:flex;align-items:center;gap:12px;">
                    <span style="font-size:24px;"><?php echo e($parentCategory->icon ?? '📦'); ?></span>
                    <div>
                        <strong style="font-size:16px;color:#1f2937;"><?php echo e($parentCategory->name); ?></strong>
                        <div style="font-size:12px;color:#6b7280;margin-top:2px;">
                            Slug: <?php echo e($parentCategory->slug); ?> | 
                            Sıra: <?php echo e($parentCategory->order); ?> |
                            <?php if($parentCategory->is_active): ?>
                                <span style="color:green;">Aktif</span>
                            <?php else: ?>
                                <span style="color:red;">Pasif</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div style="display:flex;gap:8px;">
                    <a class="btn btn-sm" href="<?php echo e(route('admin.categories.edit', $parentCategory)); ?>">Düzenle</a>
                    <form action="<?php echo e(route('admin.categories.destroy', $parentCategory)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Bu kategoriyi silmek istediğinize emin misiniz? Alt kategoriler ve ürünler de silinecek.');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-sm btn-danger">Sil</button>
                    </form>
                </div>
            </div>
            
            <?php if($parentCategory->children->count() > 0): ?>
                <div style="margin-top:15px;padding-left:20px;border-left:3px solid #3b82f6;">
                    <strong style="font-size:14px;color:#6b7280;display:block;margin-bottom:10px;">Alt Kategoriler:</strong>
                    <?php $__currentLoopData = $parentCategory->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div style="display:flex;align-items:center;justify-content:space-between;padding:10px;background:#fff;border:1px solid #e5e7eb;border-radius:4px;margin-bottom:8px;">
                            <div style="display:flex;align-items:center;gap:10px;">
                                <span style="font-size:20px;"><?php echo e($childCategory->icon ?? '📦'); ?></span>
                                <div>
                                    <strong style="font-size:14px;"><?php echo e($childCategory->name); ?></strong>
                                    <div style="font-size:11px;color:#9ca3af;">
                                        Slug: <?php echo e($childCategory->slug); ?> | Sıra: <?php echo e($childCategory->order); ?>

                                        <?php if($childCategory->is_active): ?>
                                            <span style="color:green;">• Aktif</span>
                                        <?php else: ?>
                                            <span style="color:red;">• Pasif</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div style="display:flex;gap:6px;">
                                <a class="btn btn-sm" href="<?php echo e(route('admin.categories.edit', $childCategory)); ?>" style="font-size:12px;padding:4px 12px;">Düzenle</a>
                                <form action="<?php echo e(route('admin.categories.destroy', $childCategory)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Bu kategoriyi silmek istediğinize emin misiniz?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" style="font-size:12px;padding:4px 12px;">Sil</button>
                                </form>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    <?php if($categories->whereNull('parent_id')->count() == 0): ?>
        <p style="color:#6b7280;text-align:center;padding:40px;">Henüz kategori bulunmuyor. İlk kategoriyi oluşturun.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/categories/index.blade.php ENDPATH**/ ?>