
<?php $__env->startSection('content'); ?>
    <style>
        .search-wrapper { max-width: 1200px; margin: 0 auto; padding: 30px 16px; }
        
        .page-header { margin-bottom: 30px; }
        .page-header h1 { font-size: 32px; font-weight: 700; color: #333; margin-bottom: 10px; }
        .page-header .search-info { font-size: 14px; color: #666; }
        .page-header .search-info strong { color: #73ae43; }
        
        .products-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(220px, 1fr)); gap: 25px; }
    </style>

    <div class="search-wrapper">
        <div class="page-header">
            <h1>Arama Sonuçları</h1>
            <?php if($searchTerm): ?>
                <div class="search-info">
                    "<strong><?php echo e($searchTerm); ?></strong>" için <strong><?php echo e($products->total()); ?></strong> sonuç bulundu.
                </div>
            <?php else: ?>
                <div class="search-info">Lütfen arama terimi girin.</div>
            <?php endif; ?>
        </div>

        <?php if($products->count() > 0): ?>
            <?php echo $__env->make('partials.product-grid', ['products' => $products], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            
            <div style="margin-top: 30px; display: flex; justify-content: center;">
                <?php echo e($products->links()); ?>

            </div>
        <?php else: ?>
            <div style="text-align: center; padding: 60px 20px; background: #f0f9f4; border-radius: 12px;">
                <div style="font-size: 48px; margin-bottom: 20px;">🔍</div>
                <h2 style="font-size: 24px; color: #333; margin-bottom: 10px;">Sonuç bulunamadı</h2>
                <p style="color: #666; margin-bottom: 20px;">Aradığınız kriterlere uygun ürün bulunamadı.</p>
                <a href="<?php echo e(route('product.index')); ?>" style="display: inline-block; background: #73ae43; color: #fff; padding: 12px 24px; border-radius: 6px; text-decoration: none; font-weight: 600;">Tüm Ürünleri Gör</a>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/product/search.blade.php ENDPATH**/ ?>