<section class="ticiContainer t-mt-2 t-mb-2">
    <style>
        .product-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 20px; }
        
        .product-item { background: #fff; border: 1px solid #e5e7eb; border-radius: 12px; overflow: hidden; transition: all 0.3s; position: relative; }
        .product-item:hover { transform: translateY(-5px); box-shadow: 0 8px 20px rgba(0,0,0,0.1); }
        
        .product-image-wrapper { position: relative; width: 100%; padding-top: 100%; background: #f9fafb; }
        .product-image-wrapper img { position: absolute; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover; }
        
        .product-badges { position: absolute; top: 10px; left: 10px; display: flex; flex-direction: column; gap: 8px; z-index: 2; }
        .badge-organic { background: #10b981; color: #fff; padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; display: flex; align-items: center; gap: 4px; }
        .badge-discount { background: #10b981; color: #fff; padding: 6px 10px; border-radius: 50%; font-size: 12px; font-weight: 700; width: 45px; height: 45px; display: flex; align-items: center; justify-content: center; }
        
        .product-info { padding: 15px; }
        .product-rating { display: flex; align-items: center; gap: 4px; margin-bottom: 8px; }
        .product-rating .stars { display: flex; gap: 2px; }
        .product-rating .star { font-size: 16px; color: #ddd; }
        .product-rating .star.filled { color: #ffc107; }
        .product-name { font-weight: 600; font-size: 14px; color: #333; margin-bottom: 8px; line-height: 1.4; min-height: 40px; }
        .product-farm { font-size: 12px; color: #666; margin-bottom: 8px; }
        .product-price-section { margin-bottom: 12px; }
        .product-price { font-weight: 700; color: #73ae43; font-size: 18px; }
        .product-old-price { font-size: 13px; color: #999; text-decoration: line-through; margin-top: 4px; }
        
        .product-actions { display: flex; gap: 8px; align-items: center; }
        .quantity-selector { display: flex; align-items: center; gap: 4px; border: 1px solid #e5e7eb; border-radius: 6px; padding: 2px 4px; flex-shrink: 0; }
        .quantity-btn { width: 24px; height: 24px; border: none; background: #f0f9f4; color: #73ae43; border-radius: 4px; cursor: pointer; font-size: 14px; display: flex; align-items: center; justify-content: center; padding: 0; }
        .quantity-btn:hover { background: #d1fae5; }
        .quantity-input { width: 32px; height: 24px; border: none; text-align: center; font-size: 12px; font-weight: 600; padding: 0; }
        .btn-add-cart { flex: 1; background: #ff6b35; color: #fff; padding: 10px; border-radius: 6px; font-size: 13px; font-weight: 600; text-align: center; border: none; cursor: pointer; transition: all 0.3s; text-decoration: none; display: block; }
        .btn-add-cart:hover { background: #e55a2b; transform: translateY(-2px); }
        .btn-in-cart { background: #10b981; }
        
        /* Tüm karta tıklanabilir yap */
        .product-item-link { text-decoration: none; color: inherit; display: block; }
        .product-item-link:hover { text-decoration: none; }
        .product-info { cursor: pointer; }
        .product-actions { cursor: default; }
        .product-actions * { cursor: pointer; }
        .product-actions button, .product-actions input, .product-actions a { cursor: pointer; }
    </style>
    
    <div class="product-grid">
        @foreach ($products as $product)
            <div class="product-item">
                <a href="{{ route('product.show', $product->slug) }}" class="product-item-link">
                    <div class="product-image-wrapper">
                        <img src="{{ $product->image ? asset($product->image) : asset('images/placeholder.png') }}" alt="{{ $product->name }}">
                        <div class="product-badges">
                            @if($product->is_organic)
                                <div class="badge-organic">
                                    <span>🌿</span>
                                    <span>organik</span>
                                </div>
                            @endif
                            @if($product->sale_price && $product->price > $product->sale_price)
                                @php
                                    $discount = round((($product->price - $product->sale_price) / $product->price) * 100);
                                @endphp
                                <div class="badge-discount">%{{ $discount }}</div>
                            @endif
                        </div>
                    </div>
                    <div class="product-info" onclick="event.stopPropagation();">
                    <div class="product-rating">
                        @php
                            $avgRating = $product->average_rating ?? $product->rating;
                            $fullStars = floor($avgRating);
                        @endphp
                        @for ($i = 0; $i < 5; $i++)
                            @if ($i < $fullStars)
                                <span class="star filled">★</span>
                            @else
                                <span class="star">☆</span>
                            @endif
                        @endfor
                    </div>
                        <div class="product-name">{{ $product->name }}</div>
                        @if($product->farm_name || $product->origin)
                            <div class="product-farm">
                                @if($product->farm_name)
                                    {{ $product->farm_name }}
                                @endif
                                @if($product->origin)
                                    @if($product->farm_name) - @endif
                                    {{ $product->origin }}
                                @endif
                            </div>
                        @endif
                        <div class="product-price-section">
                            <div class="product-price">
                                @if($product->sale_price)
                                    {{ number_format($product->sale_price, 2, ',', '.') }} TL
                                @else
                                    {{ number_format($product->price, 2, ',', '.') }} TL
                                @endif
                            </div>
                            @if($product->sale_price && $product->price > $product->sale_price)
                                <div class="product-old-price">{{ number_format($product->price, 2, ',', '.') }} TL</div>
                            @endif
                        </div>
                    </div>
                </a>
                <div class="product-actions" onclick="event.stopPropagation();">
                    <div class="quantity-selector">
                        <button class="quantity-btn" onclick="event.stopPropagation(); decreaseQty({{ $product->id }})">-</button>
                        <input type="number" id="qty-{{ $product->id }}" class="quantity-input" value="1" min="1" max="{{ $product->stock_quantity > 0 ? $product->stock_quantity : 99 }}" onclick="event.stopPropagation();">
                        <button class="quantity-btn" onclick="event.stopPropagation(); increaseQty({{ $product->id }})">+</button>
                    </div>
                    <a href="{{ route('product.show', $product->slug) }}" class="btn-add-cart" onclick="event.stopPropagation();" {{ !$product->in_stock ? 'style="opacity:0.5;pointer-events:none;"' : '' }}>
                        {{ $product->in_stock ? 'SEPETE EKLE' : 'STOKTA YOK' }}
                    </a>
                </div>
            </div>
        @endforeach
    </div>

    <script>
        function increaseQty(productId) {
            const input = document.getElementById('qty-' + productId);
            const max = parseInt(input.getAttribute('max')) || 99;
            const current = parseInt(input.value) || 1;
            if (current < max) {
                input.value = current + 1;
            }
        }

        function decreaseQty(productId) {
            const input = document.getElementById('qty-' + productId);
            const current = parseInt(input.value) || 1;
            if (current > 1) {
                input.value = current - 1;
            }
        }
    </script>
</section>
