<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('addresses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('title'); // Ev, İş, vb.
            $table->string('first_name');
            $table->string('last_name');
            $table->string('phone', 20);
            $table->string('city');
            $table->string('district');
            $table->text('address');
            $table->string('postal_code', 10)->nullable();
            $table->boolean('is_default')->default(false);
            $table->enum('type', ['delivery', 'billing', 'both'])->default('both');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('addresses');
    }
};
