<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Order;

class PageController extends Controller
{
    public function contact()
    {
        $page = \App\Models\Page::where('slug', 'Iletisim')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'Iletisim',
                'title' => 'İletişim',
                'content' => '',
                'is_active' => true,
            ]);
        }
        return view('pages.contact', compact('page'));
    }

    public function blog()
    {
        $page = \App\Models\Page::where('slug', 'blog')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'blog',
                'title' => 'Blog',
                'content' => '',
                'is_active' => true,
            ]);
        }
        return view('pages.blog', compact('page'));
    }

    public function login()
    {
        return view('auth.login');
    }

    public function faq()
    {
        $page = \App\Models\Page::where('slug', 'sik-sorulan-sorular-8')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'sik-sorulan-sorular-8',
                'title' => 'Sık Sorulan Sorular',
                'content' => '',
                'is_active' => true,
            ]);
        }
        return view('pages.faq', compact('page'));
    }

    public function about()
    {
        $page = \App\Models\Page::where('slug', 'neden-tazemasa-26')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'neden-tazemasa-26',
                'title' => 'Neden Tazemasa',
                'content' => '',
                'is_active' => true,
            ]);
        }
        return view('pages.about', compact('page'));
    }

    public function privacy()
    {
        $page = \App\Models\Page::where('slug', 'gizlilik-ve-guvenlik-9')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'gizlilik-ve-guvenlik-9',
                'title' => 'Gizlilik ve Güvenlik',
                'content' => '',
                'is_active' => true,
            ]);
        }
        return view('pages.privacy', compact('page'));
    }

    public function terms()
    {
        $page = \App\Models\Page::where('slug', 'kullanim-kosullari-6')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'kullanim-kosullari-6',
                'title' => 'Kullanım Koşulları',
                'content' => '',
                'is_active' => true,
            ]);
        }
        return view('pages.terms', compact('page'));
    }

    public function paraPuanNedir()
    {
        $page = \App\Models\Page::where('slug', 'para-puan-nedir')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'para-puan-nedir',
                'title' => 'Para Puan Nedir?',
                'content' => '',
                'is_active' => true,
            ]);
        }
        return view('pages.para-puan-nedir', compact('page'));
    }

    public function organikSertifikalar()
    {
        $page = \App\Models\Page::where('slug', 'organik-sertifikalar')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'organik-sertifikalar',
                'title' => 'Organik Sertifikalar',
                'content' => '',
                'is_active' => true,
            ]);
        }
        return view('pages.organik-sertifikalar', compact('page'));
    }

    public function siparisTakip(Request $request)
    {
        $page = \App\Models\Page::where('slug', 'siparisin-nerede')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'siparisin-nerede',
                'title' => 'Siparişin Nerede',
                'content' => '',
                'is_active' => true,
            ]);
        }
        
        $order = null;
        $trackingCode = $request->input('code');
        
        if ($trackingCode) {
            $order = \App\Models\Order::where('tracking_code', $trackingCode)
                ->with(['items', 'user'])
                ->first();
        }
        
        return view('pages.siparis-takip', compact('page', 'order', 'trackingCode'));
    }

    public function sevkiyat()
    {
        $page = \App\Models\Page::where('slug', 'sevkiyat')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'sevkiyat',
                'title' => 'Sevkiyat',
                'content' => '',
                'is_active' => true,
            ]);
        }
        return view('pages.sevkiyat', compact('page'));
    }

    public function yardim()
    {
        $page = \App\Models\Page::where('slug', 'yardim')->first();
        if (!$page) {
            $page = \App\Models\Page::create([
                'slug' => 'yardim',
                'title' => 'Yardım',
                'content' => '',
                'is_active' => true,
            ]);
        }
        return view('pages.yardim', compact('page'));
    }
}

